<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Certification_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: As of v13, certification name and issuer are no longer required. You may submit a certification reference or a name and issuer. | Contains the certification profile's information for a position.
 * @subpackage Structs
 */
class Certification_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: The country of certification.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Certification_Reference
     * Meta information extracted from the WSDL
     * - documentation: The certification ID reference.
     * - minOccurs: 0
     * @var \StructType\CertificationObjectType
     */
    public $Certification_Reference;
    /**
     * The Certification_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of Certification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Certification_Name;
    /**
     * The Certification_Issuer
     * Meta information extracted from the WSDL
     * - documentation: The Issuer of Certification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Certification_Issuer;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * The Specialty_Achievement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Specialty_Achievement_DataType[]
     */
    public $Specialty_Achievement_Data;
    /**
     * Constructor method for Certification_Profile_for_Job_DataType
     * @uses Certification_Profile_for_Job_DataType::setCountry_Reference()
     * @uses Certification_Profile_for_Job_DataType::setCertification_Reference()
     * @uses Certification_Profile_for_Job_DataType::setCertification_Name()
     * @uses Certification_Profile_for_Job_DataType::setCertification_Issuer()
     * @uses Certification_Profile_for_Job_DataType::setRequired()
     * @uses Certification_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @uses Certification_Profile_for_Job_DataType::setSpecialty_Achievement_Data()
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\CertificationObjectType $certification_Reference
     * @param string $certification_Name
     * @param string $certification_Issuer
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @param \StructType\Specialty_Achievement_DataType[] $specialty_Achievement_Data
     */
    public function __construct(\StructType\CountryObjectType $country_Reference = null, \StructType\CertificationObjectType $certification_Reference = null, $certification_Name = null, $certification_Issuer = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null, array $specialty_Achievement_Data = array())
    {
        $this
            ->setCountry_Reference($country_Reference)
            ->setCertification_Reference($certification_Reference)
            ->setCertification_Name($certification_Name)
            ->setCertification_Issuer($certification_Issuer)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference)
            ->setSpecialty_Achievement_Data($specialty_Achievement_Data);
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Certification_Reference value
     * @return \StructType\CertificationObjectType|null
     */
    public function getCertification_Reference()
    {
        return $this->Certification_Reference;
    }
    /**
     * Set Certification_Reference value
     * @param \StructType\CertificationObjectType $certification_Reference
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setCertification_Reference(\StructType\CertificationObjectType $certification_Reference = null)
    {
        $this->Certification_Reference = $certification_Reference;
        return $this;
    }
    /**
     * Get Certification_Name value
     * @return string|null
     */
    public function getCertification_Name()
    {
        return $this->Certification_Name;
    }
    /**
     * Set Certification_Name value
     * @param string $certification_Name
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setCertification_Name($certification_Name = null)
    {
        // validation for constraint: string
        if (!is_null($certification_Name) && !is_string($certification_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certification_Name, true), gettype($certification_Name)), __LINE__);
        }
        $this->Certification_Name = $certification_Name;
        return $this;
    }
    /**
     * Get Certification_Issuer value
     * @return string|null
     */
    public function getCertification_Issuer()
    {
        return $this->Certification_Issuer;
    }
    /**
     * Set Certification_Issuer value
     * @param string $certification_Issuer
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setCertification_Issuer($certification_Issuer = null)
    {
        // validation for constraint: string
        if (!is_null($certification_Issuer) && !is_string($certification_Issuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certification_Issuer, true), gettype($certification_Issuer)), __LINE__);
        }
        $this->Certification_Issuer = $certification_Issuer;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
    /**
     * Get Specialty_Achievement_Data value
     * @return \StructType\Specialty_Achievement_DataType[]|null
     */
    public function getSpecialty_Achievement_Data()
    {
        return $this->Specialty_Achievement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialty_Achievement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialty_Achievement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialty_Achievement_DataForArrayConstraintsFromSetSpecialty_Achievement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem) {
            // validation for constraint: itemType
            if (!$certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem instanceof \StructType\Specialty_Achievement_DataType) {
                $invalidValues[] = is_object($certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem) ? get_class($certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem) : sprintf('%s(%s)', gettype($certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem), var_export($certification_Profile_for_Job_DataTypeSpecialty_Achievement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Specialty_Achievement_Data property can only contain items of type \StructType\Specialty_Achievement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Specialty_Achievement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Specialty_Achievement_DataType[] $specialty_Achievement_Data
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function setSpecialty_Achievement_Data(array $specialty_Achievement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($specialty_Achievement_DataArrayErrorMessage = self::validateSpecialty_Achievement_DataForArrayConstraintsFromSetSpecialty_Achievement_Data($specialty_Achievement_Data))) {
            throw new \InvalidArgumentException($specialty_Achievement_DataArrayErrorMessage, __LINE__);
        }
        $this->Specialty_Achievement_Data = $specialty_Achievement_Data;
        return $this;
    }
    /**
     * Add item to Specialty_Achievement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Specialty_Achievement_DataType $item
     * @return \StructType\Certification_Profile_for_Job_DataType
     */
    public function addToSpecialty_Achievement_Data(\StructType\Specialty_Achievement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Specialty_Achievement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Specialty_Achievement_Data property can only contain items of type \StructType\Specialty_Achievement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Specialty_Achievement_Data[] = $item;
        return $this;
    }
}
