<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Social_Media_Account_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains social media account data for a candidate.
 * @subpackage Structs
 */
class Candidate_Social_Media_Account_DataType extends AbstractStructBase
{
    /**
     * The Social_Network_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Valid IDs are: Facebook, LinkedIn, Twitter, Google+. However they must be configured through Maintain Social Network Types
     * - minOccurs: 0
     * @var \StructType\Social_Network_TypeObjectType
     */
    public $Social_Network_Type_Reference;
    /**
     * The Social_Network_Account_URL
     * Meta information extracted from the WSDL
     * - documentation: The social network account URL for the candidate.
     * - choice: Social_Network_Account_URL | Social_Network_Account_User_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Social_Network_Account_URL;
    /**
     * The Social_Network_Account_User_Name
     * Meta information extracted from the WSDL
     * - documentation: The social network account user name for the candidate.
     * - choice: Social_Network_Account_URL | Social_Network_Account_User_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Social_Network_Account_User_Name;
    /**
     * Constructor method for Candidate_Social_Media_Account_DataType
     * @uses Candidate_Social_Media_Account_DataType::setSocial_Network_Type_Reference()
     * @uses Candidate_Social_Media_Account_DataType::setSocial_Network_Account_URL()
     * @uses Candidate_Social_Media_Account_DataType::setSocial_Network_Account_User_Name()
     * @param \StructType\Social_Network_TypeObjectType $social_Network_Type_Reference
     * @param string $social_Network_Account_URL
     * @param string $social_Network_Account_User_Name
     */
    public function __construct(\StructType\Social_Network_TypeObjectType $social_Network_Type_Reference = null, $social_Network_Account_URL = null, $social_Network_Account_User_Name = null)
    {
        $this
            ->setSocial_Network_Type_Reference($social_Network_Type_Reference)
            ->setSocial_Network_Account_URL($social_Network_Account_URL)
            ->setSocial_Network_Account_User_Name($social_Network_Account_User_Name);
    }
    /**
     * Get Social_Network_Type_Reference value
     * @return \StructType\Social_Network_TypeObjectType|null
     */
    public function getSocial_Network_Type_Reference()
    {
        return $this->Social_Network_Type_Reference;
    }
    /**
     * Set Social_Network_Type_Reference value
     * @param \StructType\Social_Network_TypeObjectType $social_Network_Type_Reference
     * @return \StructType\Candidate_Social_Media_Account_DataType
     */
    public function setSocial_Network_Type_Reference(\StructType\Social_Network_TypeObjectType $social_Network_Type_Reference = null)
    {
        $this->Social_Network_Type_Reference = $social_Network_Type_Reference;
        return $this;
    }
    /**
     * Get Social_Network_Account_URL value
     * @return string|null
     */
    public function getSocial_Network_Account_URL()
    {
        return isset($this->Social_Network_Account_URL) ? $this->Social_Network_Account_URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSocial_Network_Account_URL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocial_Network_Account_URL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSocial_Network_Account_URLForChoiceConstraintsFromSetSocial_Network_Account_URL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Social_Network_Account_User_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Social_Network_Account_URL can\'t be set as the property %s is already set. Only one property must be set among these properties: Social_Network_Account_URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Social_Network_Account_URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $social_Network_Account_URL
     * @return \StructType\Candidate_Social_Media_Account_DataType
     */
    public function setSocial_Network_Account_URL($social_Network_Account_URL = null)
    {
        // validation for constraint: string
        if (!is_null($social_Network_Account_URL) && !is_string($social_Network_Account_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($social_Network_Account_URL, true), gettype($social_Network_Account_URL)), __LINE__);
        }
        // validation for constraint: choice(Social_Network_Account_URL, Social_Network_Account_User_Name)
        if ('' !== ($social_Network_Account_URLChoiceErrorMessage = self::validateSocial_Network_Account_URLForChoiceConstraintsFromSetSocial_Network_Account_URL($social_Network_Account_URL))) {
            throw new \InvalidArgumentException($social_Network_Account_URLChoiceErrorMessage, __LINE__);
        }
        if (is_null($social_Network_Account_URL) || (is_array($social_Network_Account_URL) && empty($social_Network_Account_URL))) {
            unset($this->Social_Network_Account_URL);
        } else {
            $this->Social_Network_Account_URL = $social_Network_Account_URL;
        }
        return $this;
    }
    /**
     * Get Social_Network_Account_User_Name value
     * @return string|null
     */
    public function getSocial_Network_Account_User_Name()
    {
        return isset($this->Social_Network_Account_User_Name) ? $this->Social_Network_Account_User_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSocial_Network_Account_User_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocial_Network_Account_User_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSocial_Network_Account_User_NameForChoiceConstraintsFromSetSocial_Network_Account_User_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Social_Network_Account_URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Social_Network_Account_User_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Social_Network_Account_User_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Social_Network_Account_User_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $social_Network_Account_User_Name
     * @return \StructType\Candidate_Social_Media_Account_DataType
     */
    public function setSocial_Network_Account_User_Name($social_Network_Account_User_Name = null)
    {
        // validation for constraint: string
        if (!is_null($social_Network_Account_User_Name) && !is_string($social_Network_Account_User_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($social_Network_Account_User_Name, true), gettype($social_Network_Account_User_Name)), __LINE__);
        }
        // validation for constraint: choice(Social_Network_Account_URL, Social_Network_Account_User_Name)
        if ('' !== ($social_Network_Account_User_NameChoiceErrorMessage = self::validateSocial_Network_Account_User_NameForChoiceConstraintsFromSetSocial_Network_Account_User_Name($social_Network_Account_User_Name))) {
            throw new \InvalidArgumentException($social_Network_Account_User_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($social_Network_Account_User_Name) || (is_array($social_Network_Account_User_Name) && empty($social_Network_Account_User_Name))) {
            unset($this->Social_Network_Account_User_Name);
        } else {
            $this->Social_Network_Account_User_Name = $social_Network_Account_User_Name;
        }
        return $this;
    }
}
