<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Reminder_Settings_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create default values for a Candidate Reminder associated with a job requisition.
 * @subpackage Structs
 */
class Candidate_Reminder_Settings_DataType extends AbstractStructBase
{
    /**
     * The Notification_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Notification Template for Candidate Reminder Category.
     * - minOccurs: 0
     * @var \StructType\Notification_Template_AbstractObjectType
     */
    public $Notification_Template_Reference;
    /**
     * The Message_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Associate the Candidate Reminder directly with a Message Template.
     * - minOccurs: 0
     * @var \StructType\Message_TemplateObjectType
     */
    public $Message_Template_Reference;
    /**
     * The Edit_Message_Content
     * Meta information extracted from the WSDL
     * - documentation: Edit Message to add custom values.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Edit_Message_Content;
    /**
     * The Notification_Channel_Message
     * Meta information extracted from the WSDL
     * - documentation: Add email or push notification message content.
     * - minOccurs: 0
     * @var \StructType\Notification_Channel_MessageType
     */
    public $Notification_Channel_Message;
    /**
     * The Days_Before_Interview
     * Meta information extracted from the WSDL
     * - documentation: Days before interview to send the reminder.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 3
     * @var float
     */
    public $Days_Before_Interview;
    /**
     * The Approximate_Time_Reference
     * Meta information extracted from the WSDL
     * - documentation: Approximate time to send the interview reminder.
     * @var \StructType\Twenty_Four_Hour_TimeObjectType
     */
    public $Approximate_Time_Reference;
    /**
     * Constructor method for Candidate_Reminder_Settings_DataType
     * @uses Candidate_Reminder_Settings_DataType::setNotification_Template_Reference()
     * @uses Candidate_Reminder_Settings_DataType::setMessage_Template_Reference()
     * @uses Candidate_Reminder_Settings_DataType::setEdit_Message_Content()
     * @uses Candidate_Reminder_Settings_DataType::setNotification_Channel_Message()
     * @uses Candidate_Reminder_Settings_DataType::setDays_Before_Interview()
     * @uses Candidate_Reminder_Settings_DataType::setApproximate_Time_Reference()
     * @param \StructType\Notification_Template_AbstractObjectType $notification_Template_Reference
     * @param \StructType\Message_TemplateObjectType $message_Template_Reference
     * @param bool $edit_Message_Content
     * @param \StructType\Notification_Channel_MessageType $notification_Channel_Message
     * @param float $days_Before_Interview
     * @param \StructType\Twenty_Four_Hour_TimeObjectType $approximate_Time_Reference
     */
    public function __construct(\StructType\Notification_Template_AbstractObjectType $notification_Template_Reference = null, \StructType\Message_TemplateObjectType $message_Template_Reference = null, $edit_Message_Content = null, \StructType\Notification_Channel_MessageType $notification_Channel_Message = null, $days_Before_Interview = null, \StructType\Twenty_Four_Hour_TimeObjectType $approximate_Time_Reference = null)
    {
        $this
            ->setNotification_Template_Reference($notification_Template_Reference)
            ->setMessage_Template_Reference($message_Template_Reference)
            ->setEdit_Message_Content($edit_Message_Content)
            ->setNotification_Channel_Message($notification_Channel_Message)
            ->setDays_Before_Interview($days_Before_Interview)
            ->setApproximate_Time_Reference($approximate_Time_Reference);
    }
    /**
     * Get Notification_Template_Reference value
     * @return \StructType\Notification_Template_AbstractObjectType|null
     */
    public function getNotification_Template_Reference()
    {
        return $this->Notification_Template_Reference;
    }
    /**
     * Set Notification_Template_Reference value
     * @param \StructType\Notification_Template_AbstractObjectType $notification_Template_Reference
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setNotification_Template_Reference(\StructType\Notification_Template_AbstractObjectType $notification_Template_Reference = null)
    {
        $this->Notification_Template_Reference = $notification_Template_Reference;
        return $this;
    }
    /**
     * Get Message_Template_Reference value
     * @return \StructType\Message_TemplateObjectType|null
     */
    public function getMessage_Template_Reference()
    {
        return $this->Message_Template_Reference;
    }
    /**
     * Set Message_Template_Reference value
     * @param \StructType\Message_TemplateObjectType $message_Template_Reference
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setMessage_Template_Reference(\StructType\Message_TemplateObjectType $message_Template_Reference = null)
    {
        $this->Message_Template_Reference = $message_Template_Reference;
        return $this;
    }
    /**
     * Get Edit_Message_Content value
     * @return bool|null
     */
    public function getEdit_Message_Content()
    {
        return $this->Edit_Message_Content;
    }
    /**
     * Set Edit_Message_Content value
     * @param bool $edit_Message_Content
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setEdit_Message_Content($edit_Message_Content = null)
    {
        // validation for constraint: boolean
        if (!is_null($edit_Message_Content) && !is_bool($edit_Message_Content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($edit_Message_Content, true), gettype($edit_Message_Content)), __LINE__);
        }
        $this->Edit_Message_Content = $edit_Message_Content;
        return $this;
    }
    /**
     * Get Notification_Channel_Message value
     * @return \StructType\Notification_Channel_MessageType|null
     */
    public function getNotification_Channel_Message()
    {
        return $this->Notification_Channel_Message;
    }
    /**
     * Set Notification_Channel_Message value
     * @param \StructType\Notification_Channel_MessageType $notification_Channel_Message
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setNotification_Channel_Message(\StructType\Notification_Channel_MessageType $notification_Channel_Message = null)
    {
        $this->Notification_Channel_Message = $notification_Channel_Message;
        return $this;
    }
    /**
     * Get Days_Before_Interview value
     * @return float|null
     */
    public function getDays_Before_Interview()
    {
        return $this->Days_Before_Interview;
    }
    /**
     * Set Days_Before_Interview value
     * @param float $days_Before_Interview
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setDays_Before_Interview($days_Before_Interview = null)
    {
        // validation for constraint: float
        if (!is_null($days_Before_Interview) && !(is_float($days_Before_Interview) || is_numeric($days_Before_Interview))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($days_Before_Interview, true), gettype($days_Before_Interview)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($days_Before_Interview) && mb_strlen(mb_substr($days_Before_Interview, false !== mb_strpos($days_Before_Interview, '.') ? mb_strpos($days_Before_Interview, '.') + 1 : mb_strlen($days_Before_Interview))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($days_Before_Interview, true), mb_strlen(mb_substr($days_Before_Interview, mb_strpos($days_Before_Interview, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($days_Before_Interview) && $days_Before_Interview < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($days_Before_Interview, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($days_Before_Interview) && mb_strlen(preg_replace('/(\D)/', '', $days_Before_Interview)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($days_Before_Interview, true), mb_strlen(preg_replace('/(\D)/', '', $days_Before_Interview))), __LINE__);
        }
        $this->Days_Before_Interview = $days_Before_Interview;
        return $this;
    }
    /**
     * Get Approximate_Time_Reference value
     * @return \StructType\Twenty_Four_Hour_TimeObjectType|null
     */
    public function getApproximate_Time_Reference()
    {
        return $this->Approximate_Time_Reference;
    }
    /**
     * Set Approximate_Time_Reference value
     * @param \StructType\Twenty_Four_Hour_TimeObjectType $approximate_Time_Reference
     * @return \StructType\Candidate_Reminder_Settings_DataType
     */
    public function setApproximate_Time_Reference(\StructType\Twenty_Four_Hour_TimeObjectType $approximate_Time_Reference = null)
    {
        $this->Approximate_Time_Reference = $approximate_Time_Reference;
        return $this;
    }
}
