<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Language_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Language Achievement information
 * @subpackage Structs
 */
class Candidate_Language_DataType extends AbstractStructBase
{
    /**
     * The Native
     * Meta information extracted from the WSDL
     * - documentation: Native Language
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Native;
    /**
     * The Language_Ability
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Language Ability
     * - maxOccurs: unbounded
     * @var \StructType\Language_AbilityType[]
     */
    public $Language_Ability;
    /**
     * Constructor method for Candidate_Language_DataType
     * @uses Candidate_Language_DataType::setNative()
     * @uses Candidate_Language_DataType::setLanguage_Ability()
     * @param bool $native
     * @param \StructType\Language_AbilityType[] $language_Ability
     */
    public function __construct($native = null, array $language_Ability = array())
    {
        $this
            ->setNative($native)
            ->setLanguage_Ability($language_Ability);
    }
    /**
     * Get Native value
     * @return bool|null
     */
    public function getNative()
    {
        return $this->Native;
    }
    /**
     * Set Native value
     * @param bool $native
     * @return \StructType\Candidate_Language_DataType
     */
    public function setNative($native = null)
    {
        // validation for constraint: boolean
        if (!is_null($native) && !is_bool($native)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($native, true), gettype($native)), __LINE__);
        }
        $this->Native = $native;
        return $this;
    }
    /**
     * Get Language_Ability value
     * @return \StructType\Language_AbilityType[]|null
     */
    public function getLanguage_Ability()
    {
        return $this->Language_Ability;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage_Ability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage_Ability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguage_AbilityForArrayConstraintsFromSetLanguage_Ability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Language_DataTypeLanguage_AbilityItem) {
            // validation for constraint: itemType
            if (!$candidate_Language_DataTypeLanguage_AbilityItem instanceof \StructType\Language_AbilityType) {
                $invalidValues[] = is_object($candidate_Language_DataTypeLanguage_AbilityItem) ? get_class($candidate_Language_DataTypeLanguage_AbilityItem) : sprintf('%s(%s)', gettype($candidate_Language_DataTypeLanguage_AbilityItem), var_export($candidate_Language_DataTypeLanguage_AbilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language_Ability property can only contain items of type \StructType\Language_AbilityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language_Ability value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_AbilityType[] $language_Ability
     * @return \StructType\Candidate_Language_DataType
     */
    public function setLanguage_Ability(array $language_Ability = array())
    {
        // validation for constraint: array
        if ('' !== ($language_AbilityArrayErrorMessage = self::validateLanguage_AbilityForArrayConstraintsFromSetLanguage_Ability($language_Ability))) {
            throw new \InvalidArgumentException($language_AbilityArrayErrorMessage, __LINE__);
        }
        $this->Language_Ability = $language_Ability;
        return $this;
    }
    /**
     * Add item to Language_Ability value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_AbilityType $item
     * @return \StructType\Candidate_Language_DataType
     */
    public function addToLanguage_Ability(\StructType\Language_AbilityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language_AbilityType) {
            throw new \InvalidArgumentException(sprintf('The Language_Ability property can only contain items of type \StructType\Language_AbilityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language_Ability[] = $item;
        return $this;
    }
}
