<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Job_Applied_To_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the jobs the candidate has applied to.
 * @subpackage Structs
 */
class Candidate_Job_Applied_To_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the job application.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Application_ID;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the candidate and their photo.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Application_Date
     * Meta information extracted from the WSDL
     * - documentation: Creation Moment for the Job Application
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Application_Date;
    /**
     * The Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a recruiting stage.
     * @var \StructType\Recruiting_Stage__Workday_Owned_ObjectType
     */
    public $Stage_Reference;
    /**
     * The Workflow_Step_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a workflow step within a recruiting stage
     * - minOccurs: 0
     * @var \StructType\Workflow_StepObjectType
     */
    public $Workflow_Step_Reference;
    /**
     * The Disposition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a recruiting disposition.
     * - minOccurs: 0
     * @var \StructType\Recruiting_DispositionObjectType
     */
    public $Disposition_Reference;
    /**
     * The Status_Timestamp
     * Meta information extracted from the WSDL
     * - documentation: The timestamp for this status update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status_Timestamp;
    /**
     * The Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an applicant source.
     * - minOccurs: 0
     * @var \StructType\Applicant_SourceObjectType
     */
    public $Source_Reference;
    /**
     * The Referred_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a worker who referred the Candidate
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Referred_By_Worker_Reference;
    /**
     * The Added_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a worker who create the Job Application
     * - minOccurs: 0
     * @var \StructType\Process_maintained_RoleObjectType
     */
    public $Added_By_Worker_Reference;
    /**
     * The Criteria_Match_Score_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY. Contains the skills match score when the application has received a score.
     * - minOccurs: 0
     * @var \StructType\Job_Application_Skills_Match_Score_CategoryObjectType
     */
    public $Criteria_Match_Score_Reference;
    /**
     * The Personal_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains Candidate Personal Info: Gender, Ethnicity, Hispanic/Latino, Military Service, Disabilities
     * - choice: Personal_Information_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Application_Personal_Information_DataType
     */
    public $Personal_Information_Data;
    /**
     * The Global_Personal_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains Candidate Personal Info: Gender, Date of Birth, Country of Birth, Place of Birth Region, Place of Birth City, Ethnicity, Social Benefits Locality, Marital Status, Hispanic/Latino, Military Service, Religion, Citizenship
     * Status , Primary Nationality, Additional Nationalities, Relative Name, Disabilities, Sexual Orientation Gender Identity
     * - minOccurs: 0
     * @var \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public $Global_Personal_Information_Data;
    /**
     * Constructor method for Candidate_Job_Applied_To_DataType
     * @uses Candidate_Job_Applied_To_DataType::setJob_Application_ID()
     * @uses Candidate_Job_Applied_To_DataType::setJob_Requisition_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setJob_Application_Date()
     * @uses Candidate_Job_Applied_To_DataType::setStage_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setWorkflow_Step_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setDisposition_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setStatus_Timestamp()
     * @uses Candidate_Job_Applied_To_DataType::setSource_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setReferred_By_Worker_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setAdded_By_Worker_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setCriteria_Match_Score_Reference()
     * @uses Candidate_Job_Applied_To_DataType::setPersonal_Information_Data()
     * @uses Candidate_Job_Applied_To_DataType::setGlobal_Personal_Information_Data()
     * @param string $job_Application_ID
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param string $job_Application_Date
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference
     * @param \StructType\Workflow_StepObjectType $workflow_Step_Reference
     * @param \StructType\Recruiting_DispositionObjectType $disposition_Reference
     * @param string $status_Timestamp
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @param \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference
     * @param \StructType\Job_Application_Skills_Match_Score_CategoryObjectType $criteria_Match_Score_Reference
     * @param \StructType\Application_Personal_Information_DataType $personal_Information_Data
     * @param \StructType\Person_Biographic_and_Demographic_Information_DataType $global_Personal_Information_Data
     */
    public function __construct($job_Application_ID = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, $job_Application_Date = null, \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference = null, \StructType\Workflow_StepObjectType $workflow_Step_Reference = null, \StructType\Recruiting_DispositionObjectType $disposition_Reference = null, $status_Timestamp = null, \StructType\Applicant_SourceObjectType $source_Reference = null, \StructType\WorkerObjectType $referred_By_Worker_Reference = null, \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference = null, \StructType\Job_Application_Skills_Match_Score_CategoryObjectType $criteria_Match_Score_Reference = null, \StructType\Application_Personal_Information_DataType $personal_Information_Data = null, \StructType\Person_Biographic_and_Demographic_Information_DataType $global_Personal_Information_Data = null)
    {
        $this
            ->setJob_Application_ID($job_Application_ID)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Application_Date($job_Application_Date)
            ->setStage_Reference($stage_Reference)
            ->setWorkflow_Step_Reference($workflow_Step_Reference)
            ->setDisposition_Reference($disposition_Reference)
            ->setStatus_Timestamp($status_Timestamp)
            ->setSource_Reference($source_Reference)
            ->setReferred_By_Worker_Reference($referred_By_Worker_Reference)
            ->setAdded_By_Worker_Reference($added_By_Worker_Reference)
            ->setCriteria_Match_Score_Reference($criteria_Match_Score_Reference)
            ->setPersonal_Information_Data($personal_Information_Data)
            ->setGlobal_Personal_Information_Data($global_Personal_Information_Data);
    }
    /**
     * Get Job_Application_ID value
     * @return string|null
     */
    public function getJob_Application_ID()
    {
        return $this->Job_Application_ID;
    }
    /**
     * Set Job_Application_ID value
     * @param string $job_Application_ID
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setJob_Application_ID($job_Application_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Application_ID) && !is_string($job_Application_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Application_ID, true), gettype($job_Application_ID)), __LINE__);
        }
        $this->Job_Application_ID = $job_Application_ID;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Date value
     * @return string|null
     */
    public function getJob_Application_Date()
    {
        return $this->Job_Application_Date;
    }
    /**
     * Set Job_Application_Date value
     * @param string $job_Application_Date
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setJob_Application_Date($job_Application_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Application_Date) && !is_string($job_Application_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Application_Date, true), gettype($job_Application_Date)), __LINE__);
        }
        $this->Job_Application_Date = $job_Application_Date;
        return $this;
    }
    /**
     * Get Stage_Reference value
     * @return \StructType\Recruiting_Stage__Workday_Owned_ObjectType|null
     */
    public function getStage_Reference()
    {
        return $this->Stage_Reference;
    }
    /**
     * Set Stage_Reference value
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setStage_Reference(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference = null)
    {
        $this->Stage_Reference = $stage_Reference;
        return $this;
    }
    /**
     * Get Workflow_Step_Reference value
     * @return \StructType\Workflow_StepObjectType|null
     */
    public function getWorkflow_Step_Reference()
    {
        return $this->Workflow_Step_Reference;
    }
    /**
     * Set Workflow_Step_Reference value
     * @param \StructType\Workflow_StepObjectType $workflow_Step_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setWorkflow_Step_Reference(\StructType\Workflow_StepObjectType $workflow_Step_Reference = null)
    {
        $this->Workflow_Step_Reference = $workflow_Step_Reference;
        return $this;
    }
    /**
     * Get Disposition_Reference value
     * @return \StructType\Recruiting_DispositionObjectType|null
     */
    public function getDisposition_Reference()
    {
        return $this->Disposition_Reference;
    }
    /**
     * Set Disposition_Reference value
     * @param \StructType\Recruiting_DispositionObjectType $disposition_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setDisposition_Reference(\StructType\Recruiting_DispositionObjectType $disposition_Reference = null)
    {
        $this->Disposition_Reference = $disposition_Reference;
        return $this;
    }
    /**
     * Get Status_Timestamp value
     * @return string|null
     */
    public function getStatus_Timestamp()
    {
        return $this->Status_Timestamp;
    }
    /**
     * Set Status_Timestamp value
     * @param string $status_Timestamp
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setStatus_Timestamp($status_Timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($status_Timestamp) && !is_string($status_Timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status_Timestamp, true), gettype($status_Timestamp)), __LINE__);
        }
        $this->Status_Timestamp = $status_Timestamp;
        return $this;
    }
    /**
     * Get Source_Reference value
     * @return \StructType\Applicant_SourceObjectType|null
     */
    public function getSource_Reference()
    {
        return $this->Source_Reference;
    }
    /**
     * Set Source_Reference value
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setSource_Reference(\StructType\Applicant_SourceObjectType $source_Reference = null)
    {
        $this->Source_Reference = $source_Reference;
        return $this;
    }
    /**
     * Get Referred_By_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getReferred_By_Worker_Reference()
    {
        return $this->Referred_By_Worker_Reference;
    }
    /**
     * Set Referred_By_Worker_Reference value
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setReferred_By_Worker_Reference(\StructType\WorkerObjectType $referred_By_Worker_Reference = null)
    {
        $this->Referred_By_Worker_Reference = $referred_By_Worker_Reference;
        return $this;
    }
    /**
     * Get Added_By_Worker_Reference value
     * @return \StructType\Process_maintained_RoleObjectType|null
     */
    public function getAdded_By_Worker_Reference()
    {
        return $this->Added_By_Worker_Reference;
    }
    /**
     * Set Added_By_Worker_Reference value
     * @param \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setAdded_By_Worker_Reference(\StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference = null)
    {
        $this->Added_By_Worker_Reference = $added_By_Worker_Reference;
        return $this;
    }
    /**
     * Get Criteria_Match_Score_Reference value
     * @return \StructType\Job_Application_Skills_Match_Score_CategoryObjectType|null
     */
    public function getCriteria_Match_Score_Reference()
    {
        return $this->Criteria_Match_Score_Reference;
    }
    /**
     * Set Criteria_Match_Score_Reference value
     * @param \StructType\Job_Application_Skills_Match_Score_CategoryObjectType $criteria_Match_Score_Reference
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setCriteria_Match_Score_Reference(\StructType\Job_Application_Skills_Match_Score_CategoryObjectType $criteria_Match_Score_Reference = null)
    {
        $this->Criteria_Match_Score_Reference = $criteria_Match_Score_Reference;
        return $this;
    }
    /**
     * Get Personal_Information_Data value
     * @return \StructType\Application_Personal_Information_DataType|null
     */
    public function getPersonal_Information_Data()
    {
        return isset($this->Personal_Information_Data) ? $this->Personal_Information_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonal_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonal_Information_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonal_Information_DataForChoiceConstraintsFromSetPersonal_Information_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Personal_Information_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Personal_Information_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Personal_Information_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Personal_Information_DataType $personal_Information_Data
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setPersonal_Information_Data(\StructType\Application_Personal_Information_DataType $personal_Information_Data = null)
    {
        // validation for constraint: choice(Personal_Information_Data)
        if ('' !== ($personal_Information_DataChoiceErrorMessage = self::validatePersonal_Information_DataForChoiceConstraintsFromSetPersonal_Information_Data($personal_Information_Data))) {
            throw new \InvalidArgumentException($personal_Information_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($personal_Information_Data) || (is_array($personal_Information_Data) && empty($personal_Information_Data))) {
            unset($this->Personal_Information_Data);
        } else {
            $this->Personal_Information_Data = $personal_Information_Data;
        }
        return $this;
    }
    /**
     * Get Global_Personal_Information_Data value
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType|null
     */
    public function getGlobal_Personal_Information_Data()
    {
        return $this->Global_Personal_Information_Data;
    }
    /**
     * Set Global_Personal_Information_Data value
     * @param \StructType\Person_Biographic_and_Demographic_Information_DataType $global_Personal_Information_Data
     * @return \StructType\Candidate_Job_Applied_To_DataType
     */
    public function setGlobal_Personal_Information_Data(\StructType\Person_Biographic_and_Demographic_Information_DataType $global_Personal_Information_Data = null)
    {
        $this->Global_Personal_Information_Data = $global_Personal_Information_Data;
        return $this;
    }
}
