<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Candidate data.
 * @subpackage Structs
 */
class Candidate_DataType extends AbstractStructBase
{
    /**
     * The Candidate_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Candidate_ID;
    /**
     * The Pre_Hire_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the pre-hire that is the candidate.
     * - minOccurs: 0
     * @var \StructType\ApplicantObjectType
     */
    public $Pre_Hire_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the worker that is the candidate.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains candidate first and last name data.
     * - minOccurs: 0
     * @var \StructType\Candidate_Name_DataType
     */
    public $Name_Data;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for the candidate's contact data.
     * - minOccurs: 0
     * @var \StructType\Candidate_Contact_DataType
     */
    public $Contact_Data;
    /**
     * The Social_Media_Account_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the candidate's social media account data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Social_Media_Account_DataType[]
     */
    public $Social_Media_Account_Data;
    /**
     * The Status_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Status_DataType
     */
    public $Status_Data;
    /**
     * The Job_Application_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Application_DataType[]
     */
    public $Job_Application_Data;
    /**
     * The Prospect_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Prospect_DataType
     */
    public $Prospect_Data;
    /**
     * The Referral_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Referral_DataType
     */
    public $Referral_Data;
    /**
     * The Candidate_Identification_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Identification_DataType
     */
    public $Candidate_Identification_Data;
    /**
     * The Language_Reference
     * Meta information extracted from the WSDL
     * - documentation: This operation allows adding a new language user preference for external candidates.
     * - minOccurs: 0
     * @var \StructType\User_LanguageObjectType
     */
    public $Language_Reference;
    /**
     * The Candidate_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the candidate tags for the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_TagObjectType[]
     */
    public $Candidate_Tag_Reference;
    /**
     * The Candidate_Pool_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Pool_DataType
     */
    public $Candidate_Pool_Data;
    /**
     * The Candidate_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Attachment_DataType[]
     */
    public $Candidate_Attachment_Data;
    /**
     * Constructor method for Candidate_DataType
     * @uses Candidate_DataType::setCandidate_ID()
     * @uses Candidate_DataType::setPre_Hire_Reference()
     * @uses Candidate_DataType::setWorker_Reference()
     * @uses Candidate_DataType::setName_Data()
     * @uses Candidate_DataType::setContact_Data()
     * @uses Candidate_DataType::setSocial_Media_Account_Data()
     * @uses Candidate_DataType::setStatus_Data()
     * @uses Candidate_DataType::setJob_Application_Data()
     * @uses Candidate_DataType::setProspect_Data()
     * @uses Candidate_DataType::setReferral_Data()
     * @uses Candidate_DataType::setCandidate_Identification_Data()
     * @uses Candidate_DataType::setLanguage_Reference()
     * @uses Candidate_DataType::setCandidate_Tag_Reference()
     * @uses Candidate_DataType::setCandidate_Pool_Data()
     * @uses Candidate_DataType::setCandidate_Attachment_Data()
     * @param string $candidate_ID
     * @param \StructType\ApplicantObjectType $pre_Hire_Reference
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\Candidate_Name_DataType $name_Data
     * @param \StructType\Candidate_Contact_DataType $contact_Data
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $social_Media_Account_Data
     * @param \StructType\Candidate_Status_DataType $status_Data
     * @param \StructType\Job_Application_DataType[] $job_Application_Data
     * @param \StructType\Recruiting_Prospect_DataType $prospect_Data
     * @param \StructType\Referral_DataType $referral_Data
     * @param \StructType\Candidate_Identification_DataType $candidate_Identification_Data
     * @param \StructType\User_LanguageObjectType $language_Reference
     * @param \StructType\Candidate_TagObjectType[] $candidate_Tag_Reference
     * @param \StructType\Candidate_Pool_DataType $candidate_Pool_Data
     * @param \StructType\Candidate_Attachment_DataType[] $candidate_Attachment_Data
     */
    public function __construct($candidate_ID = null, \StructType\ApplicantObjectType $pre_Hire_Reference = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\Candidate_Name_DataType $name_Data = null, \StructType\Candidate_Contact_DataType $contact_Data = null, array $social_Media_Account_Data = array(), \StructType\Candidate_Status_DataType $status_Data = null, array $job_Application_Data = array(), \StructType\Recruiting_Prospect_DataType $prospect_Data = null, \StructType\Referral_DataType $referral_Data = null, \StructType\Candidate_Identification_DataType $candidate_Identification_Data = null, \StructType\User_LanguageObjectType $language_Reference = null, array $candidate_Tag_Reference = array(), \StructType\Candidate_Pool_DataType $candidate_Pool_Data = null, array $candidate_Attachment_Data = array())
    {
        $this
            ->setCandidate_ID($candidate_ID)
            ->setPre_Hire_Reference($pre_Hire_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setName_Data($name_Data)
            ->setContact_Data($contact_Data)
            ->setSocial_Media_Account_Data($social_Media_Account_Data)
            ->setStatus_Data($status_Data)
            ->setJob_Application_Data($job_Application_Data)
            ->setProspect_Data($prospect_Data)
            ->setReferral_Data($referral_Data)
            ->setCandidate_Identification_Data($candidate_Identification_Data)
            ->setLanguage_Reference($language_Reference)
            ->setCandidate_Tag_Reference($candidate_Tag_Reference)
            ->setCandidate_Pool_Data($candidate_Pool_Data)
            ->setCandidate_Attachment_Data($candidate_Attachment_Data);
    }
    /**
     * Get Candidate_ID value
     * @return string|null
     */
    public function getCandidate_ID()
    {
        return $this->Candidate_ID;
    }
    /**
     * Set Candidate_ID value
     * @param string $candidate_ID
     * @return \StructType\Candidate_DataType
     */
    public function setCandidate_ID($candidate_ID = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_ID) && !is_string($candidate_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_ID, true), gettype($candidate_ID)), __LINE__);
        }
        $this->Candidate_ID = $candidate_ID;
        return $this;
    }
    /**
     * Get Pre_Hire_Reference value
     * @return \StructType\ApplicantObjectType|null
     */
    public function getPre_Hire_Reference()
    {
        return $this->{'Pre-Hire_Reference'};
    }
    /**
     * Set Pre_Hire_Reference value
     * @param \StructType\ApplicantObjectType $pre_Hire_Reference
     * @return \StructType\Candidate_DataType
     */
    public function setPre_Hire_Reference(\StructType\ApplicantObjectType $pre_Hire_Reference = null)
    {
        $this->Pre_Hire_Reference = $this->{'Pre-Hire_Reference'} = $pre_Hire_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Candidate_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Name_Data value
     * @return \StructType\Candidate_Name_DataType|null
     */
    public function getName_Data()
    {
        return $this->Name_Data;
    }
    /**
     * Set Name_Data value
     * @param \StructType\Candidate_Name_DataType $name_Data
     * @return \StructType\Candidate_DataType
     */
    public function setName_Data(\StructType\Candidate_Name_DataType $name_Data = null)
    {
        $this->Name_Data = $name_Data;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Candidate_Contact_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Candidate_Contact_DataType $contact_Data
     * @return \StructType\Candidate_DataType
     */
    public function setContact_Data(\StructType\Candidate_Contact_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
    /**
     * Get Social_Media_Account_Data value
     * @return \StructType\Candidate_Social_Media_Account_DataType[]|null
     */
    public function getSocial_Media_Account_Data()
    {
        return $this->Social_Media_Account_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSocial_Media_Account_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocial_Media_Account_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocial_Media_Account_DataForArrayConstraintsFromSetSocial_Media_Account_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_DataTypeSocial_Media_Account_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_DataTypeSocial_Media_Account_DataItem instanceof \StructType\Candidate_Social_Media_Account_DataType) {
                $invalidValues[] = is_object($candidate_DataTypeSocial_Media_Account_DataItem) ? get_class($candidate_DataTypeSocial_Media_Account_DataItem) : sprintf('%s(%s)', gettype($candidate_DataTypeSocial_Media_Account_DataItem), var_export($candidate_DataTypeSocial_Media_Account_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $social_Media_Account_Data
     * @return \StructType\Candidate_DataType
     */
    public function setSocial_Media_Account_Data(array $social_Media_Account_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($social_Media_Account_DataArrayErrorMessage = self::validateSocial_Media_Account_DataForArrayConstraintsFromSetSocial_Media_Account_Data($social_Media_Account_Data))) {
            throw new \InvalidArgumentException($social_Media_Account_DataArrayErrorMessage, __LINE__);
        }
        $this->Social_Media_Account_Data = $social_Media_Account_Data;
        return $this;
    }
    /**
     * Add item to Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType $item
     * @return \StructType\Candidate_DataType
     */
    public function addToSocial_Media_Account_Data(\StructType\Candidate_Social_Media_Account_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Social_Media_Account_DataType) {
            throw new \InvalidArgumentException(sprintf('The Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Social_Media_Account_Data[] = $item;
        return $this;
    }
    /**
     * Get Status_Data value
     * @return \StructType\Candidate_Status_DataType|null
     */
    public function getStatus_Data()
    {
        return $this->Status_Data;
    }
    /**
     * Set Status_Data value
     * @param \StructType\Candidate_Status_DataType $status_Data
     * @return \StructType\Candidate_DataType
     */
    public function setStatus_Data(\StructType\Candidate_Status_DataType $status_Data = null)
    {
        $this->Status_Data = $status_Data;
        return $this;
    }
    /**
     * Get Job_Application_Data value
     * @return \StructType\Job_Application_DataType[]|null
     */
    public function getJob_Application_Data()
    {
        return $this->Job_Application_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_DataForArrayConstraintsFromSetJob_Application_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_DataTypeJob_Application_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_DataTypeJob_Application_DataItem instanceof \StructType\Job_Application_DataType) {
                $invalidValues[] = is_object($candidate_DataTypeJob_Application_DataItem) ? get_class($candidate_DataTypeJob_Application_DataItem) : sprintf('%s(%s)', gettype($candidate_DataTypeJob_Application_DataItem), var_export($candidate_DataTypeJob_Application_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Data property can only contain items of type \StructType\Job_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_DataType[] $job_Application_Data
     * @return \StructType\Candidate_DataType
     */
    public function setJob_Application_Data(array $job_Application_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_DataArrayErrorMessage = self::validateJob_Application_DataForArrayConstraintsFromSetJob_Application_Data($job_Application_Data))) {
            throw new \InvalidArgumentException($job_Application_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Data = $job_Application_Data;
        return $this;
    }
    /**
     * Add item to Job_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_DataType $item
     * @return \StructType\Candidate_DataType
     */
    public function addToJob_Application_Data(\StructType\Job_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Data property can only contain items of type \StructType\Job_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Data[] = $item;
        return $this;
    }
    /**
     * Get Prospect_Data value
     * @return \StructType\Recruiting_Prospect_DataType|null
     */
    public function getProspect_Data()
    {
        return $this->Prospect_Data;
    }
    /**
     * Set Prospect_Data value
     * @param \StructType\Recruiting_Prospect_DataType $prospect_Data
     * @return \StructType\Candidate_DataType
     */
    public function setProspect_Data(\StructType\Recruiting_Prospect_DataType $prospect_Data = null)
    {
        $this->Prospect_Data = $prospect_Data;
        return $this;
    }
    /**
     * Get Referral_Data value
     * @return \StructType\Referral_DataType|null
     */
    public function getReferral_Data()
    {
        return $this->Referral_Data;
    }
    /**
     * Set Referral_Data value
     * @param \StructType\Referral_DataType $referral_Data
     * @return \StructType\Candidate_DataType
     */
    public function setReferral_Data(\StructType\Referral_DataType $referral_Data = null)
    {
        $this->Referral_Data = $referral_Data;
        return $this;
    }
    /**
     * Get Candidate_Identification_Data value
     * @return \StructType\Candidate_Identification_DataType|null
     */
    public function getCandidate_Identification_Data()
    {
        return $this->Candidate_Identification_Data;
    }
    /**
     * Set Candidate_Identification_Data value
     * @param \StructType\Candidate_Identification_DataType $candidate_Identification_Data
     * @return \StructType\Candidate_DataType
     */
    public function setCandidate_Identification_Data(\StructType\Candidate_Identification_DataType $candidate_Identification_Data = null)
    {
        $this->Candidate_Identification_Data = $candidate_Identification_Data;
        return $this;
    }
    /**
     * Get Language_Reference value
     * @return \StructType\User_LanguageObjectType|null
     */
    public function getLanguage_Reference()
    {
        return $this->Language_Reference;
    }
    /**
     * Set Language_Reference value
     * @param \StructType\User_LanguageObjectType $language_Reference
     * @return \StructType\Candidate_DataType
     */
    public function setLanguage_Reference(\StructType\User_LanguageObjectType $language_Reference = null)
    {
        $this->Language_Reference = $language_Reference;
        return $this;
    }
    /**
     * Get Candidate_Tag_Reference value
     * @return \StructType\Candidate_TagObjectType[]|null
     */
    public function getCandidate_Tag_Reference()
    {
        return $this->Candidate_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Tag_ReferenceForArrayConstraintsFromSetCandidate_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_DataTypeCandidate_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_DataTypeCandidate_Tag_ReferenceItem instanceof \StructType\Candidate_TagObjectType) {
                $invalidValues[] = is_object($candidate_DataTypeCandidate_Tag_ReferenceItem) ? get_class($candidate_DataTypeCandidate_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_DataTypeCandidate_Tag_ReferenceItem), var_export($candidate_DataTypeCandidate_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Tag_Reference property can only contain items of type \StructType\Candidate_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_TagObjectType[] $candidate_Tag_Reference
     * @return \StructType\Candidate_DataType
     */
    public function setCandidate_Tag_Reference(array $candidate_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Tag_ReferenceArrayErrorMessage = self::validateCandidate_Tag_ReferenceForArrayConstraintsFromSetCandidate_Tag_Reference($candidate_Tag_Reference))) {
            throw new \InvalidArgumentException($candidate_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Tag_Reference = $candidate_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Candidate_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_TagObjectType $item
     * @return \StructType\Candidate_DataType
     */
    public function addToCandidate_Tag_Reference(\StructType\Candidate_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Tag_Reference property can only contain items of type \StructType\Candidate_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Candidate_Pool_Data value
     * @return \StructType\Candidate_Pool_DataType|null
     */
    public function getCandidate_Pool_Data()
    {
        return $this->Candidate_Pool_Data;
    }
    /**
     * Set Candidate_Pool_Data value
     * @param \StructType\Candidate_Pool_DataType $candidate_Pool_Data
     * @return \StructType\Candidate_DataType
     */
    public function setCandidate_Pool_Data(\StructType\Candidate_Pool_DataType $candidate_Pool_Data = null)
    {
        $this->Candidate_Pool_Data = $candidate_Pool_Data;
        return $this;
    }
    /**
     * Get Candidate_Attachment_Data value
     * @return \StructType\Candidate_Attachment_DataType[]|null
     */
    public function getCandidate_Attachment_Data()
    {
        return $this->Candidate_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Attachment_DataForArrayConstraintsFromSetCandidate_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_DataTypeCandidate_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_DataTypeCandidate_Attachment_DataItem instanceof \StructType\Candidate_Attachment_DataType) {
                $invalidValues[] = is_object($candidate_DataTypeCandidate_Attachment_DataItem) ? get_class($candidate_DataTypeCandidate_Attachment_DataItem) : sprintf('%s(%s)', gettype($candidate_DataTypeCandidate_Attachment_DataItem), var_export($candidate_DataTypeCandidate_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Attachment_Data property can only contain items of type \StructType\Candidate_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Attachment_DataType[] $candidate_Attachment_Data
     * @return \StructType\Candidate_DataType
     */
    public function setCandidate_Attachment_Data(array $candidate_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Attachment_DataArrayErrorMessage = self::validateCandidate_Attachment_DataForArrayConstraintsFromSetCandidate_Attachment_Data($candidate_Attachment_Data))) {
            throw new \InvalidArgumentException($candidate_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Attachment_Data = $candidate_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Candidate_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Attachment_DataType $item
     * @return \StructType\Candidate_DataType
     */
    public function addToCandidate_Attachment_Data(\StructType\Candidate_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Attachment_Data property can only contain items of type \StructType\Candidate_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Attachment_Data[] = $item;
        return $this;
    }
}
