<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Attachment_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains reference to a candidate attachment.
 * @subpackage Structs
 */
class Candidate_Attachment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Candidate_Attachment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a candidate attachment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_AttachmentObjectType[]
     */
    public $Candidate_Attachment_Reference;
    /**
     * The Skip_Non_Existing_Instances
     * @var bool
     */
    public $Skip_Non_Existing_Instances;
    /**
     * Constructor method for Candidate_Attachment_Request_ReferencesType
     * @uses Candidate_Attachment_Request_ReferencesType::setCandidate_Attachment_Reference()
     * @uses Candidate_Attachment_Request_ReferencesType::setSkip_Non_Existing_Instances()
     * @param \StructType\Candidate_AttachmentObjectType[] $candidate_Attachment_Reference
     * @param bool $skip_Non_Existing_Instances
     */
    public function __construct(array $candidate_Attachment_Reference = array(), $skip_Non_Existing_Instances = null)
    {
        $this
            ->setCandidate_Attachment_Reference($candidate_Attachment_Reference)
            ->setSkip_Non_Existing_Instances($skip_Non_Existing_Instances);
    }
    /**
     * Get Candidate_Attachment_Reference value
     * @return \StructType\Candidate_AttachmentObjectType[]|null
     */
    public function getCandidate_Attachment_Reference()
    {
        return $this->Candidate_Attachment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Attachment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Attachment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Attachment_ReferenceForArrayConstraintsFromSetCandidate_Attachment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem instanceof \StructType\Candidate_AttachmentObjectType) {
                $invalidValues[] = is_object($candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem) ? get_class($candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem), var_export($candidate_Attachment_Request_ReferencesTypeCandidate_Attachment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Attachment_Reference property can only contain items of type \StructType\Candidate_AttachmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_AttachmentObjectType[] $candidate_Attachment_Reference
     * @return \StructType\Candidate_Attachment_Request_ReferencesType
     */
    public function setCandidate_Attachment_Reference(array $candidate_Attachment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Attachment_ReferenceArrayErrorMessage = self::validateCandidate_Attachment_ReferenceForArrayConstraintsFromSetCandidate_Attachment_Reference($candidate_Attachment_Reference))) {
            throw new \InvalidArgumentException($candidate_Attachment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Attachment_Reference = $candidate_Attachment_Reference;
        return $this;
    }
    /**
     * Add item to Candidate_Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_AttachmentObjectType $item
     * @return \StructType\Candidate_Attachment_Request_ReferencesType
     */
    public function addToCandidate_Attachment_Reference(\StructType\Candidate_AttachmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_AttachmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Attachment_Reference property can only contain items of type \StructType\Candidate_AttachmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Attachment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Skip_Non_Existing_Instances value
     * @return bool|null
     */
    public function getSkip_Non_Existing_Instances()
    {
        return $this->Skip_Non_Existing_Instances;
    }
    /**
     * Set Skip_Non_Existing_Instances value
     * @param bool $skip_Non_Existing_Instances
     * @return \StructType\Candidate_Attachment_Request_ReferencesType
     */
    public function setSkip_Non_Existing_Instances($skip_Non_Existing_Instances = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip_Non_Existing_Instances) && !is_bool($skip_Non_Existing_Instances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip_Non_Existing_Instances, true), gettype($skip_Non_Existing_Instances)), __LINE__);
        }
        $this->Skip_Non_Existing_Instances = $skip_Non_Existing_Instances;
        return $this;
    }
}
