<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Attachment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about a Attachment to add to a Candidate.
 * @subpackage Structs
 */
class Candidate_Attachment_DataType extends AbstractStructBase
{
    /**
     * The Candidate_Attachment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Candidate Attachment.
     * - minOccurs: 0
     * @var \StructType\Candidate_AttachmentObjectType
     */
    public $Candidate_Attachment_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachment_WWS_DataType
     */
    public $Attachment_Data;
    /**
     * The Document_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Identifies the category for the document.
     * @var \StructType\Document_Category__All_ObjectType
     */
    public $Document_Category_Reference;
    /**
     * Constructor method for Candidate_Attachment_DataType
     * @uses Candidate_Attachment_DataType::setCandidate_Attachment_Reference()
     * @uses Candidate_Attachment_DataType::setAttachment_Data()
     * @uses Candidate_Attachment_DataType::setDocument_Category_Reference()
     * @param \StructType\Candidate_AttachmentObjectType $candidate_Attachment_Reference
     * @param \StructType\Attachment_WWS_DataType $attachment_Data
     * @param \StructType\Document_Category__All_ObjectType $document_Category_Reference
     */
    public function __construct(\StructType\Candidate_AttachmentObjectType $candidate_Attachment_Reference = null, \StructType\Attachment_WWS_DataType $attachment_Data = null, \StructType\Document_Category__All_ObjectType $document_Category_Reference = null)
    {
        $this
            ->setCandidate_Attachment_Reference($candidate_Attachment_Reference)
            ->setAttachment_Data($attachment_Data)
            ->setDocument_Category_Reference($document_Category_Reference);
    }
    /**
     * Get Candidate_Attachment_Reference value
     * @return \StructType\Candidate_AttachmentObjectType|null
     */
    public function getCandidate_Attachment_Reference()
    {
        return $this->Candidate_Attachment_Reference;
    }
    /**
     * Set Candidate_Attachment_Reference value
     * @param \StructType\Candidate_AttachmentObjectType $candidate_Attachment_Reference
     * @return \StructType\Candidate_Attachment_DataType
     */
    public function setCandidate_Attachment_Reference(\StructType\Candidate_AttachmentObjectType $candidate_Attachment_Reference = null)
    {
        $this->Candidate_Attachment_Reference = $candidate_Attachment_Reference;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Attachment_WWS_DataType|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * Set Attachment_Data value
     * @param \StructType\Attachment_WWS_DataType $attachment_Data
     * @return \StructType\Candidate_Attachment_DataType
     */
    public function setAttachment_Data(\StructType\Attachment_WWS_DataType $attachment_Data = null)
    {
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Get Document_Category_Reference value
     * @return \StructType\Document_Category__All_ObjectType|null
     */
    public function getDocument_Category_Reference()
    {
        return $this->Document_Category_Reference;
    }
    /**
     * Set Document_Category_Reference value
     * @param \StructType\Document_Category__All_ObjectType $document_Category_Reference
     * @return \StructType\Candidate_Attachment_DataType
     */
    public function setDocument_Category_Reference(\StructType\Document_Category__All_ObjectType $document_Category_Reference = null)
    {
        $this->Document_Category_Reference = $document_Category_Reference;
        return $this;
    }
}
