<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Site Brand data.
 * @subpackage Structs
 */
class BrandType extends AbstractStructBase
{
    /**
     * The Brand_Reference
     * Meta information extracted from the WSDL
     * - documentation: Site Brand Request References
     * - minOccurs: 0
     * @var \StructType\BrandObjectType
     */
    public $Brand_Reference;
    /**
     * The Brand_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Brand_DataType
     */
    public $Brand_Data;
    /**
     * Constructor method for BrandType
     * @uses BrandType::setBrand_Reference()
     * @uses BrandType::setBrand_Data()
     * @param \StructType\BrandObjectType $brand_Reference
     * @param \StructType\Brand_DataType $brand_Data
     */
    public function __construct(\StructType\BrandObjectType $brand_Reference = null, \StructType\Brand_DataType $brand_Data = null)
    {
        $this
            ->setBrand_Reference($brand_Reference)
            ->setBrand_Data($brand_Data);
    }
    /**
     * Get Brand_Reference value
     * @return \StructType\BrandObjectType|null
     */
    public function getBrand_Reference()
    {
        return $this->Brand_Reference;
    }
    /**
     * Set Brand_Reference value
     * @param \StructType\BrandObjectType $brand_Reference
     * @return \StructType\BrandType
     */
    public function setBrand_Reference(\StructType\BrandObjectType $brand_Reference = null)
    {
        $this->Brand_Reference = $brand_Reference;
        return $this;
    }
    /**
     * Get Brand_Data value
     * @return \StructType\Brand_DataType|null
     */
    public function getBrand_Data()
    {
        return $this->Brand_Data;
    }
    /**
     * Set Brand_Data value
     * @param \StructType\Brand_DataType $brand_Data
     * @return \StructType\BrandType
     */
    public function setBrand_Data(\StructType\Brand_DataType $brand_Data = null)
    {
        $this->Brand_Data = $brand_Data;
        return $this;
    }
}
