<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Package_Test_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the background test details.
 * @subpackage Structs
 */
class Background_Check_Package_Test_DataType extends AbstractStructBase
{
    /**
     * The Background_Check_Test
     * Meta information extracted from the WSDL
     * - documentation: Name of the Background Check Package Test.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * @var string
     */
    public $Background_Check_Test;
    /**
     * The Test_Reference
     * Meta information extracted from the WSDL
     * - documentation: If the test is new, then the reference IDs should match if they both exist. Otherwise, if they do match, or if either one is missing, or if the Background Check Package Test Reference ID refers to an existing test, then either create
     * the test with the single reference ID, or update the existing one. | Validation enforcing that reference IDs must be unique for each Background Check Package Test. | Reference ID of Background Check Package Test.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Test_Reference;
    /**
     * The Background_Check_Test_Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the Background Check Package Test.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Background_Check_Test_Description;
    /**
     * Constructor method for Background_Check_Package_Test_DataType
     * @uses Background_Check_Package_Test_DataType::setBackground_Check_Test()
     * @uses Background_Check_Package_Test_DataType::setTest_Reference()
     * @uses Background_Check_Package_Test_DataType::setBackground_Check_Test_Description()
     * @param string $background_Check_Test
     * @param string $test_Reference
     * @param string $background_Check_Test_Description
     */
    public function __construct($background_Check_Test = null, $test_Reference = null, $background_Check_Test_Description = null)
    {
        $this
            ->setBackground_Check_Test($background_Check_Test)
            ->setTest_Reference($test_Reference)
            ->setBackground_Check_Test_Description($background_Check_Test_Description);
    }
    /**
     * Get Background_Check_Test value
     * @return string|null
     */
    public function getBackground_Check_Test()
    {
        return $this->Background_Check_Test;
    }
    /**
     * Set Background_Check_Test value
     * @param string $background_Check_Test
     * @return \StructType\Background_Check_Package_Test_DataType
     */
    public function setBackground_Check_Test($background_Check_Test = null)
    {
        // validation for constraint: string
        if (!is_null($background_Check_Test) && !is_string($background_Check_Test)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Check_Test, true), gettype($background_Check_Test)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($background_Check_Test) && mb_strlen($background_Check_Test) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($background_Check_Test)), __LINE__);
        }
        $this->Background_Check_Test = $background_Check_Test;
        return $this;
    }
    /**
     * Get Test_Reference value
     * @return string|null
     */
    public function getTest_Reference()
    {
        return $this->Test_Reference;
    }
    /**
     * Set Test_Reference value
     * @param string $test_Reference
     * @return \StructType\Background_Check_Package_Test_DataType
     */
    public function setTest_Reference($test_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($test_Reference) && !is_string($test_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($test_Reference, true), gettype($test_Reference)), __LINE__);
        }
        $this->Test_Reference = $test_Reference;
        return $this;
    }
    /**
     * Get Background_Check_Test_Description value
     * @return string|null
     */
    public function getBackground_Check_Test_Description()
    {
        return $this->Background_Check_Test_Description;
    }
    /**
     * Set Background_Check_Test_Description value
     * @param string $background_Check_Test_Description
     * @return \StructType\Background_Check_Package_Test_DataType
     */
    public function setBackground_Check_Test_Description($background_Check_Test_Description = null)
    {
        // validation for constraint: string
        if (!is_null($background_Check_Test_Description) && !is_string($background_Check_Test_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Check_Test_Description, true), gettype($background_Check_Test_Description)), __LINE__);
        }
        $this->Background_Check_Test_Description = $background_Check_Test_Description;
        return $this;
    }
}
