<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Package_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the Background Check Package information and contained tests.
 * @subpackage Structs
 */
class Background_Check_Package_DataType extends AbstractStructBase
{
    /**
     * The Background_Check_Package
     * Meta information extracted from the WSDL
     * - documentation: Name of the Background Check Package.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * @var string
     */
    public $Background_Check_Package;
    /**
     * The Package_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID of the Background Check Package.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Package_Reference_ID;
    /**
     * The Background_Check_Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the Background Check Package.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Background_Check_Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Background Check Package is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Background_Check_Test
     * Meta information extracted from the WSDL
     * - documentation: Information about the Background Check Package Test.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Background_Check_Package_TestType[]
     */
    public $Background_Check_Test;
    /**
     * Constructor method for Background_Check_Package_DataType
     * @uses Background_Check_Package_DataType::setBackground_Check_Package()
     * @uses Background_Check_Package_DataType::setPackage_Reference_ID()
     * @uses Background_Check_Package_DataType::setBackground_Check_Description()
     * @uses Background_Check_Package_DataType::setInactive()
     * @uses Background_Check_Package_DataType::setBackground_Check_Test()
     * @param string $background_Check_Package
     * @param string $package_Reference_ID
     * @param string $background_Check_Description
     * @param bool $inactive
     * @param \StructType\Background_Check_Package_TestType[] $background_Check_Test
     */
    public function __construct($background_Check_Package = null, $package_Reference_ID = null, $background_Check_Description = null, $inactive = null, array $background_Check_Test = array())
    {
        $this
            ->setBackground_Check_Package($background_Check_Package)
            ->setPackage_Reference_ID($package_Reference_ID)
            ->setBackground_Check_Description($background_Check_Description)
            ->setInactive($inactive)
            ->setBackground_Check_Test($background_Check_Test);
    }
    /**
     * Get Background_Check_Package value
     * @return string|null
     */
    public function getBackground_Check_Package()
    {
        return $this->Background_Check_Package;
    }
    /**
     * Set Background_Check_Package value
     * @param string $background_Check_Package
     * @return \StructType\Background_Check_Package_DataType
     */
    public function setBackground_Check_Package($background_Check_Package = null)
    {
        // validation for constraint: string
        if (!is_null($background_Check_Package) && !is_string($background_Check_Package)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Check_Package, true), gettype($background_Check_Package)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($background_Check_Package) && mb_strlen($background_Check_Package) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($background_Check_Package)), __LINE__);
        }
        $this->Background_Check_Package = $background_Check_Package;
        return $this;
    }
    /**
     * Get Package_Reference_ID value
     * @return string|null
     */
    public function getPackage_Reference_ID()
    {
        return $this->Package_Reference_ID;
    }
    /**
     * Set Package_Reference_ID value
     * @param string $package_Reference_ID
     * @return \StructType\Background_Check_Package_DataType
     */
    public function setPackage_Reference_ID($package_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($package_Reference_ID) && !is_string($package_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package_Reference_ID, true), gettype($package_Reference_ID)), __LINE__);
        }
        $this->Package_Reference_ID = $package_Reference_ID;
        return $this;
    }
    /**
     * Get Background_Check_Description value
     * @return string|null
     */
    public function getBackground_Check_Description()
    {
        return $this->Background_Check_Description;
    }
    /**
     * Set Background_Check_Description value
     * @param string $background_Check_Description
     * @return \StructType\Background_Check_Package_DataType
     */
    public function setBackground_Check_Description($background_Check_Description = null)
    {
        // validation for constraint: string
        if (!is_null($background_Check_Description) && !is_string($background_Check_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Check_Description, true), gettype($background_Check_Description)), __LINE__);
        }
        $this->Background_Check_Description = $background_Check_Description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Background_Check_Package_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Background_Check_Test value
     * @return \StructType\Background_Check_Package_TestType[]|null
     */
    public function getBackground_Check_Test()
    {
        return $this->Background_Check_Test;
    }
    /**
     * This method is responsible for validating the values passed to the setBackground_Check_Test method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBackground_Check_Test method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBackground_Check_TestForArrayConstraintsFromSetBackground_Check_Test(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_Package_DataTypeBackground_Check_TestItem) {
            // validation for constraint: itemType
            if (!$background_Check_Package_DataTypeBackground_Check_TestItem instanceof \StructType\Background_Check_Package_TestType) {
                $invalidValues[] = is_object($background_Check_Package_DataTypeBackground_Check_TestItem) ? get_class($background_Check_Package_DataTypeBackground_Check_TestItem) : sprintf('%s(%s)', gettype($background_Check_Package_DataTypeBackground_Check_TestItem), var_export($background_Check_Package_DataTypeBackground_Check_TestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Background_Check_Test property can only contain items of type \StructType\Background_Check_Package_TestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Background_Check_Test value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_Package_TestType[] $background_Check_Test
     * @return \StructType\Background_Check_Package_DataType
     */
    public function setBackground_Check_Test(array $background_Check_Test = array())
    {
        // validation for constraint: array
        if ('' !== ($background_Check_TestArrayErrorMessage = self::validateBackground_Check_TestForArrayConstraintsFromSetBackground_Check_Test($background_Check_Test))) {
            throw new \InvalidArgumentException($background_Check_TestArrayErrorMessage, __LINE__);
        }
        $this->Background_Check_Test = $background_Check_Test;
        return $this;
    }
    /**
     * Add item to Background_Check_Test value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_Package_TestType $item
     * @return \StructType\Background_Check_Package_DataType
     */
    public function addToBackground_Check_Test(\StructType\Background_Check_Package_TestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Background_Check_Package_TestType) {
            throw new \InvalidArgumentException(sprintf('The Background_Check_Test property can only contain items of type \StructType\Background_Check_Package_TestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Background_Check_Test[] = $item;
        return $this;
    }
}
