<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: The details of a resume (resume, name, comments).
 * @subpackage Structs
 */
class Attachment_Data_WWSType extends AbstractStructBase
{
    /**
     * The File_ID
     * Meta information extracted from the WSDL
     * - documentation: The Reference ID for the resume.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_ID;
    /**
     * The File
     * Meta information extracted from the WSDL
     * - documentation: A comment about the resume.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the resume.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: The resume that was attached for the applicant.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for Attachment_Data_WWSType
     * @uses Attachment_Data_WWSType::setFile_ID()
     * @uses Attachment_Data_WWSType::setFile()
     * @uses Attachment_Data_WWSType::setFileName()
     * @uses Attachment_Data_WWSType::setComments()
     * @param string $file_ID
     * @param string $file
     * @param string $fileName
     * @param string $comments
     */
    public function __construct($file_ID = null, $file = null, $fileName = null, $comments = null)
    {
        $this
            ->setFile_ID($file_ID)
            ->setFile($file)
            ->setFileName($fileName)
            ->setComments($comments);
    }
    /**
     * Get File_ID value
     * @return string|null
     */
    public function getFile_ID()
    {
        return $this->File_ID;
    }
    /**
     * Set File_ID value
     * @param string $file_ID
     * @return \StructType\Attachment_Data_WWSType
     */
    public function setFile_ID($file_ID = null)
    {
        // validation for constraint: string
        if (!is_null($file_ID) && !is_string($file_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_ID, true), gettype($file_ID)), __LINE__);
        }
        $this->File_ID = $file_ID;
        return $this;
    }
    /**
     * Get File value
     * @return string|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param string $file
     * @return \StructType\Attachment_Data_WWSType
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->File = $file;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Attachment_Data_WWSType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($fileName) && mb_strlen($fileName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\Attachment_Data_WWSType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
}
