<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Recruiting_Self-Schedule_Calendars_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This holds the calendar assignment data.
 * @subpackage Structs
 */
class Assign_Recruiting_Self_Schedule_Calendars_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to reference a Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_ID;
    /**
     * The Recruiting_Self_Schedule_Calendar_Reference
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Self-Schedule Calendar References.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Schedule_CalendarObjectType[]
     */
    public $Recruiting_Self_Schedule_Calendar_Reference;
    /**
     * Constructor method for Assign_Recruiting_Self-Schedule_Calendars_DataType
     * @uses Assign_Recruiting_Self_Schedule_Calendars_DataType::setJob_Requisition_ID()
     * @uses Assign_Recruiting_Self_Schedule_Calendars_DataType::setRecruiting_Self_Schedule_Calendar_Reference()
     * @param string $job_Requisition_ID
     * @param \StructType\Recruiting_Self_Schedule_CalendarObjectType[] $recruiting_Self_Schedule_Calendar_Reference
     */
    public function __construct($job_Requisition_ID = null, array $recruiting_Self_Schedule_Calendar_Reference = array())
    {
        $this
            ->setJob_Requisition_ID($job_Requisition_ID)
            ->setRecruiting_Self_Schedule_Calendar_Reference($recruiting_Self_Schedule_Calendar_Reference);
    }
    /**
     * Get Job_Requisition_ID value
     * @return string|null
     */
    public function getJob_Requisition_ID()
    {
        return $this->Job_Requisition_ID;
    }
    /**
     * Set Job_Requisition_ID value
     * @param string $job_Requisition_ID
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType
     */
    public function setJob_Requisition_ID($job_Requisition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_ID) && !is_string($job_Requisition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_ID, true), gettype($job_Requisition_ID)), __LINE__);
        }
        $this->Job_Requisition_ID = $job_Requisition_ID;
        return $this;
    }
    /**
     * Get Recruiting_Self_Schedule_Calendar_Reference value
     * @return \StructType\Recruiting_Self_Schedule_CalendarObjectType[]|null
     */
    public function getRecruiting_Self_Schedule_Calendar_Reference()
    {
        return $this->{'Recruiting_Self-Schedule_Calendar_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Self_Schedule_Calendar_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Self_Schedule_Calendar_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Self_Schedule_Calendar_ReferenceForArrayConstraintsFromSetRecruiting_Self_Schedule_Calendar_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem instanceof \StructType\Recruiting_Self_Schedule_CalendarObjectType) {
                $invalidValues[] = is_object($assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem) ? get_class($assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem), var_export($assign_Recruiting_Self_Schedule_Calendars_DataTypeRecruiting_Self_Schedule_Calendar_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Self_Schedule_Calendar_Reference property can only contain items of type \StructType\Recruiting_Self_Schedule_CalendarObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Self_Schedule_Calendar_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Schedule_CalendarObjectType[] $recruiting_Self_Schedule_Calendar_Reference
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType
     */
    public function setRecruiting_Self_Schedule_Calendar_Reference(array $recruiting_Self_Schedule_Calendar_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Self_Schedule_Calendar_ReferenceArrayErrorMessage = self::validateRecruiting_Self_Schedule_Calendar_ReferenceForArrayConstraintsFromSetRecruiting_Self_Schedule_Calendar_Reference($recruiting_Self_Schedule_Calendar_Reference))) {
            throw new \InvalidArgumentException($recruiting_Self_Schedule_Calendar_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Self_Schedule_Calendar_Reference = $this->{'Recruiting_Self-Schedule_Calendar_Reference'} = $recruiting_Self_Schedule_Calendar_Reference;
        return $this;
    }
    /**
     * Add item to Recruiting_Self_Schedule_Calendar_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Schedule_CalendarObjectType $item
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType
     */
    public function addToRecruiting_Self_Schedule_Calendar_Reference(\StructType\Recruiting_Self_Schedule_CalendarObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Self_Schedule_CalendarObjectType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Self_Schedule_Calendar_Reference property can only contain items of type \StructType\Recruiting_Self_Schedule_CalendarObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Self_Schedule_Calendar_Reference[] = $this->{'Recruiting_Self-Schedule_Calendar_Reference'}[] = $item;
        return $this;
    }
}
