<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assess_Candidate_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: To submit a candidate assessment request with Request Criteria, enter at least 1 of these criteria: Job Application Reference, Candidate Criteria Data, Job Application Event Reference, From Moment, To Moment. | The From Moment must
 * be less than the To Moment. | Criteria used to determine which Candidate Assessment to return.
 * @subpackage Structs
 */
class Assess_Candidate_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessments retrieved will be those associated with the referenced Job Application.
     * - choice: Job_Application_Reference | Candidate_Criteria_Data | Job_Application_Event_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Criteria_Data
     * Meta information extracted from the WSDL
     * - choice: Job_Application_Reference | Candidate_Criteria_Data | Job_Application_Event_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Candidate_CriteriaType
     */
    public $Candidate_Criteria_Data;
    /**
     * The Job_Application_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessments retrieved will be those associated with the referenced Job Application Event.
     * - choice: Job_Application_Reference | Candidate_Criteria_Data | Job_Application_Event_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Job_Application_Event_Reference;
    /**
     * The Include_Inline_Assessments
     * Meta information extracted from the WSDL
     * - documentation: Also include inline assessment tests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Inline_Assessments;
    /**
     * The From_Moment
     * Meta information extracted from the WSDL
     * - documentation: Only assessments created on or after this moment will be retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Moment;
    /**
     * The To_Moment
     * Meta information extracted from the WSDL
     * - documentation: Only assessments prior to this moment will be retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Moment;
    /**
     * Constructor method for Assess_Candidate_Request_CriteriaType
     * @uses Assess_Candidate_Request_CriteriaType::setJob_Application_Reference()
     * @uses Assess_Candidate_Request_CriteriaType::setCandidate_Criteria_Data()
     * @uses Assess_Candidate_Request_CriteriaType::setJob_Application_Event_Reference()
     * @uses Assess_Candidate_Request_CriteriaType::setInclude_Inline_Assessments()
     * @uses Assess_Candidate_Request_CriteriaType::setFrom_Moment()
     * @uses Assess_Candidate_Request_CriteriaType::setTo_Moment()
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Candidate_CriteriaType $candidate_Criteria_Data
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @param bool $include_Inline_Assessments
     * @param string $from_Moment
     * @param string $to_Moment
     */
    public function __construct(\StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Candidate_CriteriaType $candidate_Criteria_Data = null, \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null, $include_Inline_Assessments = null, $from_Moment = null, $to_Moment = null)
    {
        $this
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Criteria_Data($candidate_Criteria_Data)
            ->setJob_Application_Event_Reference($job_Application_Event_Reference)
            ->setInclude_Inline_Assessments($include_Inline_Assessments)
            ->setFrom_Moment($from_Moment)
            ->setTo_Moment($to_Moment);
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Candidate_Criteria_Data',
            'Job_Application_Event_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Reference, Candidate_Criteria_Data, Job_Application_Event_Reference)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Criteria_Data value
     * @return \StructType\Candidate_CriteriaType|null
     */
    public function getCandidate_Criteria_Data()
    {
        return isset($this->Candidate_Criteria_Data) ? $this->Candidate_Criteria_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Criteria_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Job_Application_Event_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Criteria_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Criteria_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Criteria_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_CriteriaType $candidate_Criteria_Data
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setCandidate_Criteria_Data(\StructType\Candidate_CriteriaType $candidate_Criteria_Data = null)
    {
        // validation for constraint: choice(Job_Application_Reference, Candidate_Criteria_Data, Job_Application_Event_Reference)
        if ('' !== ($candidate_Criteria_DataChoiceErrorMessage = self::validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($candidate_Criteria_Data))) {
            throw new \InvalidArgumentException($candidate_Criteria_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Criteria_Data) || (is_array($candidate_Criteria_Data) && empty($candidate_Criteria_Data))) {
            unset($this->Candidate_Criteria_Data);
        } else {
            $this->Candidate_Criteria_Data = $candidate_Criteria_Data;
        }
        return $this;
    }
    /**
     * Get Job_Application_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getJob_Application_Event_Reference()
    {
        return isset($this->Job_Application_Event_Reference) ? $this->Job_Application_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Candidate_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setJob_Application_Event_Reference(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Reference, Candidate_Criteria_Data, Job_Application_Event_Reference)
        if ('' !== ($job_Application_Event_ReferenceChoiceErrorMessage = self::validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($job_Application_Event_Reference))) {
            throw new \InvalidArgumentException($job_Application_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Event_Reference) || (is_array($job_Application_Event_Reference) && empty($job_Application_Event_Reference))) {
            unset($this->Job_Application_Event_Reference);
        } else {
            $this->Job_Application_Event_Reference = $job_Application_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Include_Inline_Assessments value
     * @return bool|null
     */
    public function getInclude_Inline_Assessments()
    {
        return $this->Include_Inline_Assessments;
    }
    /**
     * Set Include_Inline_Assessments value
     * @param bool $include_Inline_Assessments
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setInclude_Inline_Assessments($include_Inline_Assessments = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Inline_Assessments) && !is_bool($include_Inline_Assessments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Inline_Assessments, true), gettype($include_Inline_Assessments)), __LINE__);
        }
        $this->Include_Inline_Assessments = $include_Inline_Assessments;
        return $this;
    }
    /**
     * Get From_Moment value
     * @return string|null
     */
    public function getFrom_Moment()
    {
        return $this->From_Moment;
    }
    /**
     * Set From_Moment value
     * @param string $from_Moment
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setFrom_Moment($from_Moment = null)
    {
        // validation for constraint: string
        if (!is_null($from_Moment) && !is_string($from_Moment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Moment, true), gettype($from_Moment)), __LINE__);
        }
        $this->From_Moment = $from_Moment;
        return $this;
    }
    /**
     * Get To_Moment value
     * @return string|null
     */
    public function getTo_Moment()
    {
        return $this->To_Moment;
    }
    /**
     * Set To_Moment value
     * @param string $to_Moment
     * @return \StructType\Assess_Candidate_Request_CriteriaType
     */
    public function setTo_Moment($to_Moment = null)
    {
        // validation for constraint: string
        if (!is_null($to_Moment) && !is_string($to_Moment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Moment, true), gettype($to_Moment)), __LINE__);
        }
        $this->To_Moment = $to_Moment;
        return $this;
    }
}
