<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assess_Candidate_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: References to the Candidate Assessment to be created or modified along with the data to be used in the creation or modification.
 * @subpackage Structs
 */
class Assess_Candidate_Event_DataType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Assess Candidate business process event.
     * - choice: Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application relevant to the Candidate Assessment underway.
     * - choice: Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Criteria_Data
     * Meta information extracted from the WSDL
     * - choice: Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Candidate_CriteriaType
     */
    public $Candidate_Criteria_Data;
    /**
     * The Candidate_Assessment_Data
     * @var \StructType\Recruiting_Assessment_DataType
     */
    public $Candidate_Assessment_Data;
    /**
     * Constructor method for Assess_Candidate_Event_DataType
     * @uses Assess_Candidate_Event_DataType::setEvent_Reference()
     * @uses Assess_Candidate_Event_DataType::setJob_Application_Reference()
     * @uses Assess_Candidate_Event_DataType::setCandidate_Criteria_Data()
     * @uses Assess_Candidate_Event_DataType::setCandidate_Assessment_Data()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Candidate_CriteriaType $candidate_Criteria_Data
     * @param \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Candidate_CriteriaType $candidate_Criteria_Data = null, \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Criteria_Data($candidate_Criteria_Data)
            ->setCandidate_Assessment_Data($candidate_Assessment_Data);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return isset($this->Event_Reference) ? $this->Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEvent_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvent_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEvent_ReferenceForChoiceConstraintsFromSetEvent_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Candidate_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Assess_Candidate_Event_DataType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        // validation for constraint: choice(Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($event_ReferenceChoiceErrorMessage = self::validateEvent_ReferenceForChoiceConstraintsFromSetEvent_Reference($event_Reference))) {
            throw new \InvalidArgumentException($event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($event_Reference) || (is_array($event_Reference) && empty($event_Reference))) {
            unset($this->Event_Reference);
        } else {
            $this->Event_Reference = $event_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Event_Reference',
            'Candidate_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Assess_Candidate_Event_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Criteria_Data value
     * @return \StructType\Candidate_CriteriaType|null
     */
    public function getCandidate_Criteria_Data()
    {
        return isset($this->Candidate_Criteria_Data) ? $this->Candidate_Criteria_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Criteria_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Criteria_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Criteria_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Criteria_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_CriteriaType $candidate_Criteria_Data
     * @return \StructType\Assess_Candidate_Event_DataType
     */
    public function setCandidate_Criteria_Data(\StructType\Candidate_CriteriaType $candidate_Criteria_Data = null)
    {
        // validation for constraint: choice(Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($candidate_Criteria_DataChoiceErrorMessage = self::validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($candidate_Criteria_Data))) {
            throw new \InvalidArgumentException($candidate_Criteria_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Criteria_Data) || (is_array($candidate_Criteria_Data) && empty($candidate_Criteria_Data))) {
            unset($this->Candidate_Criteria_Data);
        } else {
            $this->Candidate_Criteria_Data = $candidate_Criteria_Data;
        }
        return $this;
    }
    /**
     * Get Candidate_Assessment_Data value
     * @return \StructType\Recruiting_Assessment_DataType|null
     */
    public function getCandidate_Assessment_Data()
    {
        return $this->Candidate_Assessment_Data;
    }
    /**
     * Set Candidate_Assessment_Data value
     * @param \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data
     * @return \StructType\Assess_Candidate_Event_DataType
     */
    public function setCandidate_Assessment_Data(\StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data = null)
    {
        $this->Candidate_Assessment_Data = $candidate_Assessment_Data;
        return $this;
    }
}
