<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Application_Personal_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Candidate Personal Info: Gender, Ethnicity, Hispanic/Latino, Military Service, Disabilities
 * @subpackage Structs
 */
class Application_Personal_Information_DataType extends AbstractStructBase
{
    /**
     * The Gender_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Gender
     * - minOccurs: 0
     * @var \StructType\GenderObjectType
     */
    public $Gender_Reference;
    /**
     * The Ethnicity_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify there Ethnicity. It must be recognized by the Country they are applying in.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EthnicityObjectType[]
     */
    public $Ethnicity_Reference;
    /**
     * The Veterans_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Select one or more valid Military Statuses. | Select from the valid Veteran Statuses. | You have entered Personal Information for this Candidate, however none of the jobs applied for are in locations where Personal Information is
     * captured. | Candidate can specify if they have any military status.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Armed_Forces_StatusObjectType[]
     */
    public $Veterans_Status_Reference;
    /**
     * The Hispanic_or_Latino
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify if they are of Hispanic or Latino descent
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hispanic_or_Latino;
    /**
     * The Disability_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify if they have any disabilities
     * - minOccurs: 0
     * @var \StructType\Self_Identification_of_Disability_StatusObjectType
     */
    public $Disability_Status_Reference;
    /**
     * The Disability_Status_Last_Updated_On
     * Meta information extracted from the WSDL
     * - documentation: The date the candidate’s Disability Status was last updated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Disability_Status_Last_Updated_On;
    /**
     * Constructor method for Application_Personal_Information_DataType
     * @uses Application_Personal_Information_DataType::setGender_Reference()
     * @uses Application_Personal_Information_DataType::setEthnicity_Reference()
     * @uses Application_Personal_Information_DataType::setVeterans_Status_Reference()
     * @uses Application_Personal_Information_DataType::setHispanic_or_Latino()
     * @uses Application_Personal_Information_DataType::setDisability_Status_Reference()
     * @uses Application_Personal_Information_DataType::setDisability_Status_Last_Updated_On()
     * @param \StructType\GenderObjectType $gender_Reference
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @param \StructType\Armed_Forces_StatusObjectType[] $veterans_Status_Reference
     * @param bool $hispanic_or_Latino
     * @param \StructType\Self_Identification_of_Disability_StatusObjectType $disability_Status_Reference
     * @param string $disability_Status_Last_Updated_On
     */
    public function __construct(\StructType\GenderObjectType $gender_Reference = null, array $ethnicity_Reference = array(), array $veterans_Status_Reference = array(), $hispanic_or_Latino = null, \StructType\Self_Identification_of_Disability_StatusObjectType $disability_Status_Reference = null, $disability_Status_Last_Updated_On = null)
    {
        $this
            ->setGender_Reference($gender_Reference)
            ->setEthnicity_Reference($ethnicity_Reference)
            ->setVeterans_Status_Reference($veterans_Status_Reference)
            ->setHispanic_or_Latino($hispanic_or_Latino)
            ->setDisability_Status_Reference($disability_Status_Reference)
            ->setDisability_Status_Last_Updated_On($disability_Status_Last_Updated_On);
    }
    /**
     * Get Gender_Reference value
     * @return \StructType\GenderObjectType|null
     */
    public function getGender_Reference()
    {
        return $this->Gender_Reference;
    }
    /**
     * Set Gender_Reference value
     * @param \StructType\GenderObjectType $gender_Reference
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setGender_Reference(\StructType\GenderObjectType $gender_Reference = null)
    {
        $this->Gender_Reference = $gender_Reference;
        return $this;
    }
    /**
     * Get Ethnicity_Reference value
     * @return \StructType\EthnicityObjectType[]|null
     */
    public function getEthnicity_Reference()
    {
        return $this->Ethnicity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEthnicity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEthnicity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $application_Personal_Information_DataTypeEthnicity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$application_Personal_Information_DataTypeEthnicity_ReferenceItem instanceof \StructType\EthnicityObjectType) {
                $invalidValues[] = is_object($application_Personal_Information_DataTypeEthnicity_ReferenceItem) ? get_class($application_Personal_Information_DataTypeEthnicity_ReferenceItem) : sprintf('%s(%s)', gettype($application_Personal_Information_DataTypeEthnicity_ReferenceItem), var_export($application_Personal_Information_DataTypeEthnicity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setEthnicity_Reference(array $ethnicity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ethnicity_ReferenceArrayErrorMessage = self::validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference($ethnicity_Reference))) {
            throw new \InvalidArgumentException($ethnicity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ethnicity_Reference = $ethnicity_Reference;
        return $this;
    }
    /**
     * Add item to Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType $item
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function addToEthnicity_Reference(\StructType\EthnicityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EthnicityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ethnicity_Reference[] = $item;
        return $this;
    }
    /**
     * Get Veterans_Status_Reference value
     * @return \StructType\Armed_Forces_StatusObjectType[]|null
     */
    public function getVeterans_Status_Reference()
    {
        return $this->Veterans_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setVeterans_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVeterans_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVeterans_Status_ReferenceForArrayConstraintsFromSetVeterans_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $application_Personal_Information_DataTypeVeterans_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$application_Personal_Information_DataTypeVeterans_Status_ReferenceItem instanceof \StructType\Armed_Forces_StatusObjectType) {
                $invalidValues[] = is_object($application_Personal_Information_DataTypeVeterans_Status_ReferenceItem) ? get_class($application_Personal_Information_DataTypeVeterans_Status_ReferenceItem) : sprintf('%s(%s)', gettype($application_Personal_Information_DataTypeVeterans_Status_ReferenceItem), var_export($application_Personal_Information_DataTypeVeterans_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Veterans_Status_Reference property can only contain items of type \StructType\Armed_Forces_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Veterans_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Armed_Forces_StatusObjectType[] $veterans_Status_Reference
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setVeterans_Status_Reference(array $veterans_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($veterans_Status_ReferenceArrayErrorMessage = self::validateVeterans_Status_ReferenceForArrayConstraintsFromSetVeterans_Status_Reference($veterans_Status_Reference))) {
            throw new \InvalidArgumentException($veterans_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Veterans_Status_Reference = $veterans_Status_Reference;
        return $this;
    }
    /**
     * Add item to Veterans_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Armed_Forces_StatusObjectType $item
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function addToVeterans_Status_Reference(\StructType\Armed_Forces_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Armed_Forces_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Veterans_Status_Reference property can only contain items of type \StructType\Armed_Forces_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Veterans_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hispanic_or_Latino value
     * @return bool|null
     */
    public function getHispanic_or_Latino()
    {
        return $this->Hispanic_or_Latino;
    }
    /**
     * Set Hispanic_or_Latino value
     * @param bool $hispanic_or_Latino
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setHispanic_or_Latino($hispanic_or_Latino = null)
    {
        // validation for constraint: boolean
        if (!is_null($hispanic_or_Latino) && !is_bool($hispanic_or_Latino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hispanic_or_Latino, true), gettype($hispanic_or_Latino)), __LINE__);
        }
        $this->Hispanic_or_Latino = $hispanic_or_Latino;
        return $this;
    }
    /**
     * Get Disability_Status_Reference value
     * @return \StructType\Self_Identification_of_Disability_StatusObjectType|null
     */
    public function getDisability_Status_Reference()
    {
        return $this->Disability_Status_Reference;
    }
    /**
     * Set Disability_Status_Reference value
     * @param \StructType\Self_Identification_of_Disability_StatusObjectType $disability_Status_Reference
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setDisability_Status_Reference(\StructType\Self_Identification_of_Disability_StatusObjectType $disability_Status_Reference = null)
    {
        $this->Disability_Status_Reference = $disability_Status_Reference;
        return $this;
    }
    /**
     * Get Disability_Status_Last_Updated_On value
     * @return string|null
     */
    public function getDisability_Status_Last_Updated_On()
    {
        return $this->Disability_Status_Last_Updated_On;
    }
    /**
     * Set Disability_Status_Last_Updated_On value
     * @param string $disability_Status_Last_Updated_On
     * @return \StructType\Application_Personal_Information_DataType
     */
    public function setDisability_Status_Last_Updated_On($disability_Status_Last_Updated_On = null)
    {
        // validation for constraint: string
        if (!is_null($disability_Status_Last_Updated_On) && !is_string($disability_Status_Last_Updated_On)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disability_Status_Last_Updated_On, true), gettype($disability_Status_Last_Updated_On)), __LINE__);
        }
        $this->Disability_Status_Last_Updated_On = $disability_Status_Last_Updated_On;
        return $this;
    }
}
