<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Move_Job_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Move a job requisition from one Job Management Organization to another Job Management Organization using the Move Job Requisition business process.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Move_Job_Requisition_RequestType $body
     * @return \StructType\Move_Job_Requisition_ResponseType|bool
     */
    public function Move_Job_Requisition(\StructType\Move_Job_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Move_Job_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Move_Candidate_to_Linked_Job_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will move a Job Application from an Evergreen Requisition to a Job Requisition.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Move_Candidate_to_Linked_Job_Requisition_RequestType $body
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType|bool
     */
    public function Move_Candidate_to_Linked_Job_Requisition(\StructType\Move_Candidate_to_Linked_Job_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Move_Candidate_to_Linked_Job_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Move_Candidate_to_Linked_Evergreen_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Move candidates from a Job Requisition to a linked ~Evergreen Requisition~.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Move_Candidate_to_Linked_Evergreen_Requisition_RequestType $body
     * @return \StructType\Move_Candidate_to_Linked_Evergreen_Requisition_ResponseType|bool
     */
    public function Move_Candidate_to_Linked_Evergreen_Requisition(\StructType\Move_Candidate_to_Linked_Evergreen_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Move_Candidate_to_Linked_Evergreen_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Move_Candidate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Move Candidate from any Recruiting Stage to next possible stage or to a disposition stage.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Move_Candidate_RequestType $body
     * @return \StructType\Move_Candidate_ResponseType|bool
     */
    public function Move_Candidate(\StructType\Move_Candidate_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Move_Candidate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Move_Candidate_ResponseType|\StructType\Move_Candidate_to_Linked_Evergreen_Requisition_ResponseType|\StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType|\StructType\Move_Job_Requisition_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
