<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Create_Position
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates/opens a position for a supervisory organization using the position management staffing model. Uses the Create Position business process. There are several sub-operations within this operation.Existing positions cannot be
     * re-loaded into the system. You must use the Edit Position Restrictions operation to change a created position.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Create_Position_RequestType $body
     * @return \StructType\Create_Position_ResponseType|bool
     */
    public function Create_Position(\StructType\Create_Position_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Create_Position($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Create_Job_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will create a job requisition for a position in a position management supervisory organization. The position must not have any open requisitions, and the tenant must have the Enable Job Requisitions flag set to true.
     * Requisitions cannot be reloaded into the system.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Create_Requisition_RequestType $body
     * @return \StructType\Create_Job_Requisition_ResponseType|bool
     */
    public function Create_Job_Requisition(\StructType\Create_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Create_Job_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Create_Evergreen_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will create an evergreen job requisition.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Create_Evergreen_Requisition_RequestType $body
     * @return \StructType\Create_Evergreen_Requisition_ResponseType|bool
     */
    public function Create_Evergreen_Requisition(\StructType\Create_Evergreen_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Create_Evergreen_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Create_Evergreen_Requisition_ResponseType|\StructType\Create_Job_Requisition_ResponseType|\StructType\Create_Position_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
