<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Conference_Interview_Session_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for the interview session.
 * @subpackage Structs
 */
class Web_Conference_Interview_Session_DataType extends AbstractStructBase
{
    /**
     * The Interview_Session_Reference
     * Meta information extracted from the WSDL
     * - documentation: References the interview session.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Interview_Session_Reference;
    /**
     * The Interview_Session_Start_Time
     * Meta information extracted from the WSDL
     * - documentation: Start time of the interview session.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interview_Session_Start_Time;
    /**
     * The Interview_Session_End_Time
     * Meta information extracted from the WSDL
     * - documentation: End time of the interview session.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interview_Session_End_Time;
    /**
     * The Interviewer_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data for the interviewer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interviewer_DataType[]
     */
    public $Interviewer_Data;
    /**
     * The Interview_Room_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data for the interview room.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_Room_DataType[]
     */
    public $Interview_Room_Data;
    /**
     * Constructor method for Web_Conference_Interview_Session_DataType
     * @uses Web_Conference_Interview_Session_DataType::setInterview_Session_Reference()
     * @uses Web_Conference_Interview_Session_DataType::setInterview_Session_Start_Time()
     * @uses Web_Conference_Interview_Session_DataType::setInterview_Session_End_Time()
     * @uses Web_Conference_Interview_Session_DataType::setInterviewer_Data()
     * @uses Web_Conference_Interview_Session_DataType::setInterview_Room_Data()
     * @param \StructType\Unique_IdentifierObjectType $interview_Session_Reference
     * @param string $interview_Session_Start_Time
     * @param string $interview_Session_End_Time
     * @param \StructType\Interviewer_DataType[] $interviewer_Data
     * @param \StructType\Interview_Room_DataType[] $interview_Room_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $interview_Session_Reference = null, $interview_Session_Start_Time = null, $interview_Session_End_Time = null, array $interviewer_Data = array(), array $interview_Room_Data = array())
    {
        $this
            ->setInterview_Session_Reference($interview_Session_Reference)
            ->setInterview_Session_Start_Time($interview_Session_Start_Time)
            ->setInterview_Session_End_Time($interview_Session_End_Time)
            ->setInterviewer_Data($interviewer_Data)
            ->setInterview_Room_Data($interview_Room_Data);
    }
    /**
     * Get Interview_Session_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getInterview_Session_Reference()
    {
        return $this->Interview_Session_Reference;
    }
    /**
     * Set Interview_Session_Reference value
     * @param \StructType\Unique_IdentifierObjectType $interview_Session_Reference
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function setInterview_Session_Reference(\StructType\Unique_IdentifierObjectType $interview_Session_Reference = null)
    {
        $this->Interview_Session_Reference = $interview_Session_Reference;
        return $this;
    }
    /**
     * Get Interview_Session_Start_Time value
     * @return string|null
     */
    public function getInterview_Session_Start_Time()
    {
        return $this->Interview_Session_Start_Time;
    }
    /**
     * Set Interview_Session_Start_Time value
     * @param string $interview_Session_Start_Time
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function setInterview_Session_Start_Time($interview_Session_Start_Time = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Session_Start_Time) && !is_string($interview_Session_Start_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Session_Start_Time, true), gettype($interview_Session_Start_Time)), __LINE__);
        }
        $this->Interview_Session_Start_Time = $interview_Session_Start_Time;
        return $this;
    }
    /**
     * Get Interview_Session_End_Time value
     * @return string|null
     */
    public function getInterview_Session_End_Time()
    {
        return $this->Interview_Session_End_Time;
    }
    /**
     * Set Interview_Session_End_Time value
     * @param string $interview_Session_End_Time
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function setInterview_Session_End_Time($interview_Session_End_Time = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Session_End_Time) && !is_string($interview_Session_End_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Session_End_Time, true), gettype($interview_Session_End_Time)), __LINE__);
        }
        $this->Interview_Session_End_Time = $interview_Session_End_Time;
        return $this;
    }
    /**
     * Get Interviewer_Data value
     * @return \StructType\Interviewer_DataType[]|null
     */
    public function getInterviewer_Data()
    {
        return $this->Interviewer_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterviewer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterviewer_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterviewer_DataForArrayConstraintsFromSetInterviewer_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Conference_Interview_Session_DataTypeInterviewer_DataItem) {
            // validation for constraint: itemType
            if (!$web_Conference_Interview_Session_DataTypeInterviewer_DataItem instanceof \StructType\Interviewer_DataType) {
                $invalidValues[] = is_object($web_Conference_Interview_Session_DataTypeInterviewer_DataItem) ? get_class($web_Conference_Interview_Session_DataTypeInterviewer_DataItem) : sprintf('%s(%s)', gettype($web_Conference_Interview_Session_DataTypeInterviewer_DataItem), var_export($web_Conference_Interview_Session_DataTypeInterviewer_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interviewer_Data property can only contain items of type \StructType\Interviewer_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interviewer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interviewer_DataType[] $interviewer_Data
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function setInterviewer_Data(array $interviewer_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interviewer_DataArrayErrorMessage = self::validateInterviewer_DataForArrayConstraintsFromSetInterviewer_Data($interviewer_Data))) {
            throw new \InvalidArgumentException($interviewer_DataArrayErrorMessage, __LINE__);
        }
        $this->Interviewer_Data = $interviewer_Data;
        return $this;
    }
    /**
     * Add item to Interviewer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interviewer_DataType $item
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function addToInterviewer_Data(\StructType\Interviewer_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interviewer_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interviewer_Data property can only contain items of type \StructType\Interviewer_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interviewer_Data[] = $item;
        return $this;
    }
    /**
     * Get Interview_Room_Data value
     * @return \StructType\Interview_Room_DataType[]|null
     */
    public function getInterview_Room_Data()
    {
        return $this->Interview_Room_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Room_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Room_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Room_DataForArrayConstraintsFromSetInterview_Room_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Conference_Interview_Session_DataTypeInterview_Room_DataItem) {
            // validation for constraint: itemType
            if (!$web_Conference_Interview_Session_DataTypeInterview_Room_DataItem instanceof \StructType\Interview_Room_DataType) {
                $invalidValues[] = is_object($web_Conference_Interview_Session_DataTypeInterview_Room_DataItem) ? get_class($web_Conference_Interview_Session_DataTypeInterview_Room_DataItem) : sprintf('%s(%s)', gettype($web_Conference_Interview_Session_DataTypeInterview_Room_DataItem), var_export($web_Conference_Interview_Session_DataTypeInterview_Room_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Room_Data property can only contain items of type \StructType\Interview_Room_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Room_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Room_DataType[] $interview_Room_Data
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function setInterview_Room_Data(array $interview_Room_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Room_DataArrayErrorMessage = self::validateInterview_Room_DataForArrayConstraintsFromSetInterview_Room_Data($interview_Room_Data))) {
            throw new \InvalidArgumentException($interview_Room_DataArrayErrorMessage, __LINE__);
        }
        $this->Interview_Room_Data = $interview_Room_Data;
        return $this;
    }
    /**
     * Add item to Interview_Room_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Room_DataType $item
     * @return \StructType\Web_Conference_Interview_Session_DataType
     */
    public function addToInterview_Room_Data(\StructType\Interview_Room_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_Room_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Room_Data property can only contain items of type \StructType\Interview_Room_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Room_Data[] = $item;
        return $this;
    }
}
