<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_Stock_Grant_Offer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data element for the stock grant request
 * @subpackage Structs
 */
class Request_Stock_Grant_Offer_DataType extends AbstractStructBase
{
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the stock grant becomes effective.
     * - maxOccurs: 1
     * @var string
     */
    public $Effective_Date;
    /**
     * The Stock_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Stock Plan for the Stock Grants.
     * @var \StructType\Stock_PlanObjectType
     */
    public $Stock_Plan_Reference;
    /**
     * The Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reason for the stock plan assignment. Use the format: General_Event_Subcategory.
     * - minOccurs: 0
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Reason_Reference;
    /**
     * The Shares_Granted
     * Meta information extracted from the WSDL
     * - documentation: Number of shares granted for the stock grant.
     * - base: xsd:decimal
     * - choice: Shares_Granted | Grant_Percent | Grant_Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 15
     * @var float
     */
    public $Shares_Granted;
    /**
     * The Grant_Percent
     * Meta information extracted from the WSDL
     * - documentation: Percent of compensation basis allotted to stock grant for a percent stock plan. Cannot exceed 10,000% of employee base pay.
     * - base: xsd:decimal
     * - choice: Shares_Granted | Grant_Percent | Grant_Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Grant_Percent;
    /**
     * The Grant_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount allotted for stock grant for an amount stock plan. Cannot exceed 10,000% of employee base pay.
     * - base: xsd:decimal
     * - choice: Shares_Granted | Grant_Percent | Grant_Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 26
     * @var float
     */
    public $Grant_Amount;
    /**
     * Constructor method for Request_Stock_Grant_Offer_DataType
     * @uses Request_Stock_Grant_Offer_DataType::setEffective_Date()
     * @uses Request_Stock_Grant_Offer_DataType::setStock_Plan_Reference()
     * @uses Request_Stock_Grant_Offer_DataType::setReason_Reference()
     * @uses Request_Stock_Grant_Offer_DataType::setShares_Granted()
     * @uses Request_Stock_Grant_Offer_DataType::setGrant_Percent()
     * @uses Request_Stock_Grant_Offer_DataType::setGrant_Amount()
     * @param string $effective_Date
     * @param \StructType\Stock_PlanObjectType $stock_Plan_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     * @param float $shares_Granted
     * @param float $grant_Percent
     * @param float $grant_Amount
     */
    public function __construct($effective_Date = null, \StructType\Stock_PlanObjectType $stock_Plan_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null, $shares_Granted = null, $grant_Percent = null, $grant_Amount = null)
    {
        $this
            ->setEffective_Date($effective_Date)
            ->setStock_Plan_Reference($stock_Plan_Reference)
            ->setReason_Reference($reason_Reference)
            ->setShares_Granted($shares_Granted)
            ->setGrant_Percent($grant_Percent)
            ->setGrant_Amount($grant_Amount);
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Stock_Plan_Reference value
     * @return \StructType\Stock_PlanObjectType|null
     */
    public function getStock_Plan_Reference()
    {
        return $this->Stock_Plan_Reference;
    }
    /**
     * Set Stock_Plan_Reference value
     * @param \StructType\Stock_PlanObjectType $stock_Plan_Reference
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setStock_Plan_Reference(\StructType\Stock_PlanObjectType $stock_Plan_Reference = null)
    {
        $this->Stock_Plan_Reference = $stock_Plan_Reference;
        return $this;
    }
    /**
     * Get Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getReason_Reference()
    {
        return $this->Reason_Reference;
    }
    /**
     * Set Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setReason_Reference(\StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null)
    {
        $this->Reason_Reference = $reason_Reference;
        return $this;
    }
    /**
     * Get Shares_Granted value
     * @return float|null
     */
    public function getShares_Granted()
    {
        return isset($this->Shares_Granted) ? $this->Shares_Granted : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShares_Granted method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShares_Granted method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShares_GrantedForChoiceConstraintsFromSetShares_Granted($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Grant_Percent',
            'Grant_Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Shares_Granted can\'t be set as the property %s is already set. Only one property must be set among these properties: Shares_Granted, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Shares_Granted value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $shares_Granted
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setShares_Granted($shares_Granted = null)
    {
        // validation for constraint: float
        if (!is_null($shares_Granted) && !(is_float($shares_Granted) || is_numeric($shares_Granted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shares_Granted, true), gettype($shares_Granted)), __LINE__);
        }
        // validation for constraint: choice(Shares_Granted, Grant_Percent, Grant_Amount)
        if ('' !== ($shares_GrantedChoiceErrorMessage = self::validateShares_GrantedForChoiceConstraintsFromSetShares_Granted($shares_Granted))) {
            throw new \InvalidArgumentException($shares_GrantedChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($shares_Granted) && mb_strlen(mb_substr($shares_Granted, false !== mb_strpos($shares_Granted, '.') ? mb_strpos($shares_Granted, '.') + 1 : mb_strlen($shares_Granted))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($shares_Granted, true), mb_strlen(mb_substr($shares_Granted, mb_strpos($shares_Granted, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($shares_Granted) && $shares_Granted < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($shares_Granted, true)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($shares_Granted) && mb_strlen(preg_replace('/(\D)/', '', $shares_Granted)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($shares_Granted, true), mb_strlen(preg_replace('/(\D)/', '', $shares_Granted))), __LINE__);
        }
        if (is_null($shares_Granted) || (is_array($shares_Granted) && empty($shares_Granted))) {
            unset($this->Shares_Granted);
        } else {
            $this->Shares_Granted = $shares_Granted;
        }
        return $this;
    }
    /**
     * Get Grant_Percent value
     * @return float|null
     */
    public function getGrant_Percent()
    {
        return isset($this->Grant_Percent) ? $this->Grant_Percent : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGrant_Percent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrant_Percent method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGrant_PercentForChoiceConstraintsFromSetGrant_Percent($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Shares_Granted',
            'Grant_Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Grant_Percent can\'t be set as the property %s is already set. Only one property must be set among these properties: Grant_Percent, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Grant_Percent value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $grant_Percent
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setGrant_Percent($grant_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($grant_Percent) && !(is_float($grant_Percent) || is_numeric($grant_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grant_Percent, true), gettype($grant_Percent)), __LINE__);
        }
        // validation for constraint: choice(Shares_Granted, Grant_Percent, Grant_Amount)
        if ('' !== ($grant_PercentChoiceErrorMessage = self::validateGrant_PercentForChoiceConstraintsFromSetGrant_Percent($grant_Percent))) {
            throw new \InvalidArgumentException($grant_PercentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($grant_Percent) && mb_strlen(mb_substr($grant_Percent, false !== mb_strpos($grant_Percent, '.') ? mb_strpos($grant_Percent, '.') + 1 : mb_strlen($grant_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($grant_Percent, true), mb_strlen(mb_substr($grant_Percent, mb_strpos($grant_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($grant_Percent) && $grant_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($grant_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($grant_Percent) && mb_strlen(preg_replace('/(\D)/', '', $grant_Percent)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($grant_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $grant_Percent))), __LINE__);
        }
        if (is_null($grant_Percent) || (is_array($grant_Percent) && empty($grant_Percent))) {
            unset($this->Grant_Percent);
        } else {
            $this->Grant_Percent = $grant_Percent;
        }
        return $this;
    }
    /**
     * Get Grant_Amount value
     * @return float|null
     */
    public function getGrant_Amount()
    {
        return isset($this->Grant_Amount) ? $this->Grant_Amount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGrant_Amount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrant_Amount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGrant_AmountForChoiceConstraintsFromSetGrant_Amount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Shares_Granted',
            'Grant_Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Grant_Amount can\'t be set as the property %s is already set. Only one property must be set among these properties: Grant_Amount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Grant_Amount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $grant_Amount
     * @return \StructType\Request_Stock_Grant_Offer_DataType
     */
    public function setGrant_Amount($grant_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($grant_Amount) && !(is_float($grant_Amount) || is_numeric($grant_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grant_Amount, true), gettype($grant_Amount)), __LINE__);
        }
        // validation for constraint: choice(Shares_Granted, Grant_Percent, Grant_Amount)
        if ('' !== ($grant_AmountChoiceErrorMessage = self::validateGrant_AmountForChoiceConstraintsFromSetGrant_Amount($grant_Amount))) {
            throw new \InvalidArgumentException($grant_AmountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($grant_Amount) && mb_strlen(mb_substr($grant_Amount, false !== mb_strpos($grant_Amount, '.') ? mb_strpos($grant_Amount, '.') + 1 : mb_strlen($grant_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($grant_Amount, true), mb_strlen(mb_substr($grant_Amount, mb_strpos($grant_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($grant_Amount) && $grant_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($grant_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($grant_Amount) && mb_strlen(preg_replace('/(\D)/', '', $grant_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($grant_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $grant_Amount))), __LINE__);
        }
        if (is_null($grant_Amount) || (is_array($grant_Amount) && empty($grant_Amount))) {
            unset($this->Grant_Amount);
        } else {
            $this->Grant_Amount = $grant_Amount;
        }
        return $this;
    }
}
