<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referee_Reference_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The fields to add or update referees for a reference check.
 * @subpackage Structs
 */
class Referee_Reference_DataType extends AbstractStructBase
{
    /**
     * The Referee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The referee's reference ID.
     * - minOccurs: 0
     * @var \StructType\RefereeObjectType
     */
    public $Referee_Reference;
    /**
     * The Referee_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: Information about the referee.
     * @var \StructType\Referee_Details_DataType
     */
    public $Referee_Details_Data;
    /**
     * Constructor method for Referee_Reference_DataType
     * @uses Referee_Reference_DataType::setReferee_Reference()
     * @uses Referee_Reference_DataType::setReferee_Details_Data()
     * @param \StructType\RefereeObjectType $referee_Reference
     * @param \StructType\Referee_Details_DataType $referee_Details_Data
     */
    public function __construct(\StructType\RefereeObjectType $referee_Reference = null, \StructType\Referee_Details_DataType $referee_Details_Data = null)
    {
        $this
            ->setReferee_Reference($referee_Reference)
            ->setReferee_Details_Data($referee_Details_Data);
    }
    /**
     * Get Referee_Reference value
     * @return \StructType\RefereeObjectType|null
     */
    public function getReferee_Reference()
    {
        return $this->Referee_Reference;
    }
    /**
     * Set Referee_Reference value
     * @param \StructType\RefereeObjectType $referee_Reference
     * @return \StructType\Referee_Reference_DataType
     */
    public function setReferee_Reference(\StructType\RefereeObjectType $referee_Reference = null)
    {
        $this->Referee_Reference = $referee_Reference;
        return $this;
    }
    /**
     * Get Referee_Details_Data value
     * @return \StructType\Referee_Details_DataType|null
     */
    public function getReferee_Details_Data()
    {
        return $this->Referee_Details_Data;
    }
    /**
     * Set Referee_Details_Data value
     * @param \StructType\Referee_Details_DataType $referee_Details_Data
     * @return \StructType\Referee_Reference_DataType
     */
    public function setReferee_Details_Data(\StructType\Referee_Details_DataType $referee_Details_Data = null)
    {
        $this->Referee_Details_Data = $referee_Details_Data;
        return $this;
    }
}
