<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Recruiting_Self-Service_Schedule_Time_Block_Container_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Section containing data for the Recruiting Calendar Schedule Time Block.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_Time_Block_Container_DataType extends AbstractStructBase
{
    /**
     * The Day_of_the_Week_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Day of the Week the Time Block is on.
     * @var \StructType\Day_of_the_WeekObjectType
     */
    public $Day_of_the_Week_Reference;
    /**
     * The Start_Time
     * Meta information extracted from the WSDL
     * - documentation: The start time of the time block.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Time;
    /**
     * The End_Time
     * Meta information extracted from the WSDL
     * - documentation: The end time of the time block.
     * - maxOccurs: 1
     * @var string
     */
    public $End_Time;
    /**
     * Constructor method for
     * Recruiting_Self-Service_Schedule_Time_Block_Container_DataType
     * @uses Recruiting_Self_Service_Schedule_Time_Block_Container_DataType::setDay_of_the_Week_Reference()
     * @uses Recruiting_Self_Service_Schedule_Time_Block_Container_DataType::setStart_Time()
     * @uses Recruiting_Self_Service_Schedule_Time_Block_Container_DataType::setEnd_Time()
     * @param \StructType\Day_of_the_WeekObjectType $day_of_the_Week_Reference
     * @param string $start_Time
     * @param string $end_Time
     */
    public function __construct(\StructType\Day_of_the_WeekObjectType $day_of_the_Week_Reference = null, $start_Time = null, $end_Time = null)
    {
        $this
            ->setDay_of_the_Week_Reference($day_of_the_Week_Reference)
            ->setStart_Time($start_Time)
            ->setEnd_Time($end_Time);
    }
    /**
     * Get Day_of_the_Week_Reference value
     * @return \StructType\Day_of_the_WeekObjectType|null
     */
    public function getDay_of_the_Week_Reference()
    {
        return $this->Day_of_the_Week_Reference;
    }
    /**
     * Set Day_of_the_Week_Reference value
     * @param \StructType\Day_of_the_WeekObjectType $day_of_the_Week_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType
     */
    public function setDay_of_the_Week_Reference(\StructType\Day_of_the_WeekObjectType $day_of_the_Week_Reference = null)
    {
        $this->Day_of_the_Week_Reference = $day_of_the_Week_Reference;
        return $this;
    }
    /**
     * Get Start_Time value
     * @return string|null
     */
    public function getStart_Time()
    {
        return $this->Start_Time;
    }
    /**
     * Set Start_Time value
     * @param string $start_Time
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType
     */
    public function setStart_Time($start_Time = null)
    {
        // validation for constraint: string
        if (!is_null($start_Time) && !is_string($start_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Time, true), gettype($start_Time)), __LINE__);
        }
        $this->Start_Time = $start_Time;
        return $this;
    }
    /**
     * Get End_Time value
     * @return string|null
     */
    public function getEnd_Time()
    {
        return $this->End_Time;
    }
    /**
     * Set End_Time value
     * @param string $end_Time
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_Container_DataType
     */
    public function setEnd_Time($end_Time = null)
    {
        // validation for constraint: string
        if (!is_null($end_Time) && !is_string($end_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Time, true), gettype($end_Time)), __LINE__);
        }
        $this->End_Time = $end_Time;
        return $this;
    }
}
