<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_Schedule_Excluded_DaysType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Section to add, update or delete Excluded Days for Recruiting Calendars.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_Excluded_DaysType extends AbstractStructBase
{
    /**
     * The Excluded_Days_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference an Excluded Days setting for a Recruiting Calendar.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Time_BlockObjectType
     */
    public $Excluded_Days_Reference;
    /**
     * The Excluded_Days_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public $Excluded_Days_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for adding Excluded Days.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for deleting Excluded Days.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Recruiting_Self-Service_Schedule_Excluded_DaysType
     * @uses Recruiting_Self_Service_Schedule_Excluded_DaysType::setExcluded_Days_Reference()
     * @uses Recruiting_Self_Service_Schedule_Excluded_DaysType::setExcluded_Days_Data()
     * @uses Recruiting_Self_Service_Schedule_Excluded_DaysType::setAdd_Only()
     * @uses Recruiting_Self_Service_Schedule_Excluded_DaysType::setDelete()
     * @param \StructType\Recruiting_Self_Service_Time_BlockObjectType $excluded_Days_Reference
     * @param \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType $excluded_Days_Data
     * @param bool $add_Only
     * @param bool $delete
     */
    public function __construct(\StructType\Recruiting_Self_Service_Time_BlockObjectType $excluded_Days_Reference = null, \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType $excluded_Days_Data = null, $add_Only = null, $delete = null)
    {
        $this
            ->setExcluded_Days_Reference($excluded_Days_Reference)
            ->setExcluded_Days_Data($excluded_Days_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete);
    }
    /**
     * Get Excluded_Days_Reference value
     * @return \StructType\Recruiting_Self_Service_Time_BlockObjectType|null
     */
    public function getExcluded_Days_Reference()
    {
        return $this->Excluded_Days_Reference;
    }
    /**
     * Set Excluded_Days_Reference value
     * @param \StructType\Recruiting_Self_Service_Time_BlockObjectType $excluded_Days_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType
     */
    public function setExcluded_Days_Reference(\StructType\Recruiting_Self_Service_Time_BlockObjectType $excluded_Days_Reference = null)
    {
        $this->Excluded_Days_Reference = $excluded_Days_Reference;
        return $this;
    }
    /**
     * Get Excluded_Days_Data value
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType|null
     */
    public function getExcluded_Days_Data()
    {
        return $this->Excluded_Days_Data;
    }
    /**
     * Set Excluded_Days_Data value
     * @param \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType $excluded_Days_Data
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType
     */
    public function setExcluded_Days_Data(\StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType $excluded_Days_Data = null)
    {
        $this->Excluded_Days_Data = $excluded_Days_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
