<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Schedule_Calendar_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data for the Recruiting Self-Schedule Calendar Type.
 * @subpackage Structs
 */
class Recruiting_Self_Schedule_Calendar_Type_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Self-Schedule Calendar Type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of the job requisition interview team session. | Order | The order for the Recruiting Self-Schedule Calendar Type. | The Row Order | An alphanumeric value indicating the order of this row.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Calendar_Type_Name
     * Meta information extracted from the WSDL
     * - documentation: The name for the Recruiting Self-Schedule Calendar Type.
     * - maxOccurs: 1
     * @var string
     */
    public $Calendar_Type_Name;
    /**
     * The Maps_to_Recruiting_Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: The recruiting stage mapped to by the Recruiting Self-Schedule Calendar Type.
     * @var \StructType\Recruiting_Stage__Workday_Owned_ObjectType
     */
    public $Maps_to_Recruiting_Stage_Reference;
    /**
     * The Candidate_Self_Schedule_Task_Message
     * Meta information extracted from the WSDL
     * - documentation: The message to display on the candidate self-schedule task.
     * - base: xsd:string
     * - maxOccurs: 1
     * @var string
     */
    public $Candidate_Self_Schedule_Task_Message;
    /**
     * The Candidate_Message_When_No_Time_Slots_are_Available
     * Meta information extracted from the WSDL
     * - documentation: The message that displays to a candidates when they access the self-schedule task and no time slots are available.
     * - base: xsd:string
     * - maxOccurs: 1
     * @var string
     */
    public $Candidate_Message_When_No_Time_Slots_are_Available;
    /**
     * The Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate
     * Meta information extracted from the WSDL
     * - documentation: The message that displays to a candidates when they access the self-schedule task and click the No Dates or Times Work for Me button.
     * - base: xsd:string
     * - maxOccurs: 1
     * @var string
     */
    public $Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: A boolean flag indicating that the Recruiting Self-Schedule Calendar Type is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Recruiting_Self-Schedule_Calendar_Type_DataType
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setID()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setOrder()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setCalendar_Type_Name()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setMaps_to_Recruiting_Stage_Reference()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setCandidate_Self_Schedule_Task_Message()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setCandidate_Message_When_No_Time_Slots_are_Available()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setCandidate_Message_When_No_Dates_or_Times_Work_for_Candidate()
     * @uses Recruiting_Self_Schedule_Calendar_Type_DataType::setInactive()
     * @param string $iD
     * @param string $order
     * @param string $calendar_Type_Name
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $maps_to_Recruiting_Stage_Reference
     * @param string $candidate_Self_Schedule_Task_Message
     * @param string $candidate_Message_When_No_Time_Slots_are_Available
     * @param string $candidate_Message_When_No_Dates_or_Times_Work_for_Candidate
     * @param bool $inactive
     */
    public function __construct($iD = null, $order = null, $calendar_Type_Name = null, \StructType\Recruiting_Stage__Workday_Owned_ObjectType $maps_to_Recruiting_Stage_Reference = null, $candidate_Self_Schedule_Task_Message = null, $candidate_Message_When_No_Time_Slots_are_Available = null, $candidate_Message_When_No_Dates_or_Times_Work_for_Candidate = null, $inactive = null)
    {
        $this
            ->setID($iD)
            ->setOrder($order)
            ->setCalendar_Type_Name($calendar_Type_Name)
            ->setMaps_to_Recruiting_Stage_Reference($maps_to_Recruiting_Stage_Reference)
            ->setCandidate_Self_Schedule_Task_Message($candidate_Self_Schedule_Task_Message)
            ->setCandidate_Message_When_No_Time_Slots_are_Available($candidate_Message_When_No_Time_Slots_are_Available)
            ->setCandidate_Message_When_No_Dates_or_Times_Work_for_Candidate($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate)
            ->setInactive($inactive);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Calendar_Type_Name value
     * @return string|null
     */
    public function getCalendar_Type_Name()
    {
        return $this->Calendar_Type_Name;
    }
    /**
     * Set Calendar_Type_Name value
     * @param string $calendar_Type_Name
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setCalendar_Type_Name($calendar_Type_Name = null)
    {
        // validation for constraint: string
        if (!is_null($calendar_Type_Name) && !is_string($calendar_Type_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendar_Type_Name, true), gettype($calendar_Type_Name)), __LINE__);
        }
        $this->Calendar_Type_Name = $calendar_Type_Name;
        return $this;
    }
    /**
     * Get Maps_to_Recruiting_Stage_Reference value
     * @return \StructType\Recruiting_Stage__Workday_Owned_ObjectType|null
     */
    public function getMaps_to_Recruiting_Stage_Reference()
    {
        return $this->Maps_to_Recruiting_Stage_Reference;
    }
    /**
     * Set Maps_to_Recruiting_Stage_Reference value
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $maps_to_Recruiting_Stage_Reference
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setMaps_to_Recruiting_Stage_Reference(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $maps_to_Recruiting_Stage_Reference = null)
    {
        $this->Maps_to_Recruiting_Stage_Reference = $maps_to_Recruiting_Stage_Reference;
        return $this;
    }
    /**
     * Get Candidate_Self_Schedule_Task_Message value
     * @return string|null
     */
    public function getCandidate_Self_Schedule_Task_Message()
    {
        return $this->{'Candidate_Self-Schedule_Task_Message'};
    }
    /**
     * Set Candidate_Self_Schedule_Task_Message value
     * @param string $candidate_Self_Schedule_Task_Message
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setCandidate_Self_Schedule_Task_Message($candidate_Self_Schedule_Task_Message = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_Self_Schedule_Task_Message) && !is_string($candidate_Self_Schedule_Task_Message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_Self_Schedule_Task_Message, true), gettype($candidate_Self_Schedule_Task_Message)), __LINE__);
        }
        $this->Candidate_Self_Schedule_Task_Message = $this->{'Candidate_Self-Schedule_Task_Message'} = $candidate_Self_Schedule_Task_Message;
        return $this;
    }
    /**
     * Get Candidate_Message_When_No_Time_Slots_are_Available value
     * @return string|null
     */
    public function getCandidate_Message_When_No_Time_Slots_are_Available()
    {
        return $this->Candidate_Message_When_No_Time_Slots_are_Available;
    }
    /**
     * Set Candidate_Message_When_No_Time_Slots_are_Available value
     * @param string $candidate_Message_When_No_Time_Slots_are_Available
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setCandidate_Message_When_No_Time_Slots_are_Available($candidate_Message_When_No_Time_Slots_are_Available = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_Message_When_No_Time_Slots_are_Available) && !is_string($candidate_Message_When_No_Time_Slots_are_Available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_Message_When_No_Time_Slots_are_Available, true), gettype($candidate_Message_When_No_Time_Slots_are_Available)), __LINE__);
        }
        $this->Candidate_Message_When_No_Time_Slots_are_Available = $candidate_Message_When_No_Time_Slots_are_Available;
        return $this;
    }
    /**
     * Get Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate value
     * @return string|null
     */
    public function getCandidate_Message_When_No_Dates_or_Times_Work_for_Candidate()
    {
        return $this->Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate;
    }
    /**
     * Set Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate value
     * @param string $candidate_Message_When_No_Dates_or_Times_Work_for_Candidate
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setCandidate_Message_When_No_Dates_or_Times_Work_for_Candidate($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate) && !is_string($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate, true), gettype($candidate_Message_When_No_Dates_or_Times_Work_for_Candidate)), __LINE__);
        }
        $this->Candidate_Message_When_No_Dates_or_Times_Work_for_Candidate = $candidate_Message_When_No_Dates_or_Times_Work_for_Candidate;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
