<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Assessment_Test_Result_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of information on the Assessment Test Results used in the Candidate Assessment.
 * @subpackage Structs
 */
class Recruiting_Assessment_Test_Result_DataType extends AbstractStructBase
{
    /**
     * The Assessment_Test_Result_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to an individual Assessment Test Result.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Test_ResultObjectType
     */
    public $Assessment_Test_Result_Reference;
    /**
     * The Assessment_Test_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Assessment Test used to produce the Test Result.
     * @var \StructType\Recruiting_Assessment_TestObjectType
     */
    public $Assessment_Test_Reference;
    /**
     * The Assessment_Test_Score
     * Meta information extracted from the WSDL
     * - documentation: The score the Candidate was given for the referenced Assessment Test.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Assessment_Test_Score;
    /**
     * The Assessment_Test_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the tenant supplied status for this Assessment Test Result. For example, if the test outcome was satisfactory or not.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_StatusObjectType
     */
    public $Assessment_Test_Status_Reference;
    /**
     * The Assessment_Test_Date
     * Meta information extracted from the WSDL
     * - documentation: The date that the test was taken or when the result was recorded.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Assessment_Test_Date;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: A comment on the Assessment Test Result.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Assessment_Test_Results_URL
     * Meta information extracted from the WSDL
     * - documentation: The vendor URL for the assessment results.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Assessment_Test_Results_URL;
    /**
     * Constructor method for Recruiting_Assessment_Test_Result_DataType
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Result_Reference()
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Reference()
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Score()
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Status_Reference()
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Date()
     * @uses Recruiting_Assessment_Test_Result_DataType::setComment()
     * @uses Recruiting_Assessment_Test_Result_DataType::setAssessment_Test_Results_URL()
     * @param \StructType\Recruiting_Assessment_Test_ResultObjectType $assessment_Test_Result_Reference
     * @param \StructType\Recruiting_Assessment_TestObjectType $assessment_Test_Reference
     * @param float $assessment_Test_Score
     * @param \StructType\Recruiting_Assessment_StatusObjectType $assessment_Test_Status_Reference
     * @param string $assessment_Test_Date
     * @param string $comment
     * @param string $assessment_Test_Results_URL
     */
    public function __construct(\StructType\Recruiting_Assessment_Test_ResultObjectType $assessment_Test_Result_Reference = null, \StructType\Recruiting_Assessment_TestObjectType $assessment_Test_Reference = null, $assessment_Test_Score = null, \StructType\Recruiting_Assessment_StatusObjectType $assessment_Test_Status_Reference = null, $assessment_Test_Date = null, $comment = null, $assessment_Test_Results_URL = null)
    {
        $this
            ->setAssessment_Test_Result_Reference($assessment_Test_Result_Reference)
            ->setAssessment_Test_Reference($assessment_Test_Reference)
            ->setAssessment_Test_Score($assessment_Test_Score)
            ->setAssessment_Test_Status_Reference($assessment_Test_Status_Reference)
            ->setAssessment_Test_Date($assessment_Test_Date)
            ->setComment($comment)
            ->setAssessment_Test_Results_URL($assessment_Test_Results_URL);
    }
    /**
     * Get Assessment_Test_Result_Reference value
     * @return \StructType\Recruiting_Assessment_Test_ResultObjectType|null
     */
    public function getAssessment_Test_Result_Reference()
    {
        return $this->Assessment_Test_Result_Reference;
    }
    /**
     * Set Assessment_Test_Result_Reference value
     * @param \StructType\Recruiting_Assessment_Test_ResultObjectType $assessment_Test_Result_Reference
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Result_Reference(\StructType\Recruiting_Assessment_Test_ResultObjectType $assessment_Test_Result_Reference = null)
    {
        $this->Assessment_Test_Result_Reference = $assessment_Test_Result_Reference;
        return $this;
    }
    /**
     * Get Assessment_Test_Reference value
     * @return \StructType\Recruiting_Assessment_TestObjectType|null
     */
    public function getAssessment_Test_Reference()
    {
        return $this->Assessment_Test_Reference;
    }
    /**
     * Set Assessment_Test_Reference value
     * @param \StructType\Recruiting_Assessment_TestObjectType $assessment_Test_Reference
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Reference(\StructType\Recruiting_Assessment_TestObjectType $assessment_Test_Reference = null)
    {
        $this->Assessment_Test_Reference = $assessment_Test_Reference;
        return $this;
    }
    /**
     * Get Assessment_Test_Score value
     * @return float|null
     */
    public function getAssessment_Test_Score()
    {
        return $this->Assessment_Test_Score;
    }
    /**
     * Set Assessment_Test_Score value
     * @param float $assessment_Test_Score
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Score($assessment_Test_Score = null)
    {
        // validation for constraint: float
        if (!is_null($assessment_Test_Score) && !(is_float($assessment_Test_Score) || is_numeric($assessment_Test_Score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assessment_Test_Score, true), gettype($assessment_Test_Score)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($assessment_Test_Score) && mb_strlen(mb_substr($assessment_Test_Score, false !== mb_strpos($assessment_Test_Score, '.') ? mb_strpos($assessment_Test_Score, '.') + 1 : mb_strlen($assessment_Test_Score))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($assessment_Test_Score, true), mb_strlen(mb_substr($assessment_Test_Score, mb_strpos($assessment_Test_Score, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($assessment_Test_Score) && mb_strlen(preg_replace('/(\D)/', '', $assessment_Test_Score)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($assessment_Test_Score, true), mb_strlen(preg_replace('/(\D)/', '', $assessment_Test_Score))), __LINE__);
        }
        $this->Assessment_Test_Score = $assessment_Test_Score;
        return $this;
    }
    /**
     * Get Assessment_Test_Status_Reference value
     * @return \StructType\Recruiting_Assessment_StatusObjectType|null
     */
    public function getAssessment_Test_Status_Reference()
    {
        return $this->Assessment_Test_Status_Reference;
    }
    /**
     * Set Assessment_Test_Status_Reference value
     * @param \StructType\Recruiting_Assessment_StatusObjectType $assessment_Test_Status_Reference
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Status_Reference(\StructType\Recruiting_Assessment_StatusObjectType $assessment_Test_Status_Reference = null)
    {
        $this->Assessment_Test_Status_Reference = $assessment_Test_Status_Reference;
        return $this;
    }
    /**
     * Get Assessment_Test_Date value
     * @return string|null
     */
    public function getAssessment_Test_Date()
    {
        return $this->Assessment_Test_Date;
    }
    /**
     * Set Assessment_Test_Date value
     * @param string $assessment_Test_Date
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Date($assessment_Test_Date = null)
    {
        // validation for constraint: string
        if (!is_null($assessment_Test_Date) && !is_string($assessment_Test_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessment_Test_Date, true), gettype($assessment_Test_Date)), __LINE__);
        }
        $this->Assessment_Test_Date = $assessment_Test_Date;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Assessment_Test_Results_URL value
     * @return string|null
     */
    public function getAssessment_Test_Results_URL()
    {
        return $this->Assessment_Test_Results_URL;
    }
    /**
     * Set Assessment_Test_Results_URL value
     * @param string $assessment_Test_Results_URL
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType
     */
    public function setAssessment_Test_Results_URL($assessment_Test_Results_URL = null)
    {
        // validation for constraint: string
        if (!is_null($assessment_Test_Results_URL) && !is_string($assessment_Test_Results_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessment_Test_Results_URL, true), gettype($assessment_Test_Results_URL)), __LINE__);
        }
        $this->Assessment_Test_Results_URL = $assessment_Test_Results_URL;
        return $this;
    }
}
