<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Assessment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data used to create or modify a Candidate Assessment.
 * @subpackage Structs
 */
class Recruiting_Assessment_DataType extends AbstractStructBase
{
    /**
     * The Assess_Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier for a candidate assessment. Should no other references be provided this identifier is used to find an existing Candidate Assessment. Otherwise, this identifier will be saved as part of the Candidate Assessment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Assess_Candidate_Reference;
    /**
     * The Assessed_By_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the person that provides the Candidate Assessment information.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Assessed_By_Reference;
    /**
     * The Assessed_On_Date
     * Meta information extracted from the WSDL
     * - documentation: The date upon which the Candidate Assessment was or will be performed.
     * - maxOccurs: 1
     * @var string
     */
    public $Assessed_On_Date;
    /**
     * The Assessment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to existing Assessment Statuses as defined in the tenant set up.
     * @var \StructType\Recruiting_Assessment_StatusObjectType
     */
    public $Assessment_Status_Reference;
    /**
     * The Overall_Assessment_Comment
     * Meta information extracted from the WSDL
     * - documentation: An overall comment on the Candidate Assessment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Overall_Assessment_Comment;
    /**
     * The Is_Inline_Assessment
     * Meta information extracted from the WSDL
     * - documentation: This assessment is for an inline assessment test.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Inline_Assessment;
    /**
     * The Assessment_Test_URL
     * Meta information extracted from the WSDL
     * - documentation: URL for the candidate assessment test.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Assessment_Test_URL;
    /**
     * The Assess_Candidate_Test_Result_Data
     * Meta information extracted from the WSDL
     * - documentation: Information on a set of Assessment Test Results used in concert with the Candidate Assessment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Test_Result_DataType[]
     */
    public $Assess_Candidate_Test_Result_Data;
    /**
     * Constructor method for Recruiting_Assessment_DataType
     * @uses Recruiting_Assessment_DataType::setAssess_Candidate_Reference()
     * @uses Recruiting_Assessment_DataType::setAssessed_By_Reference()
     * @uses Recruiting_Assessment_DataType::setAssessed_On_Date()
     * @uses Recruiting_Assessment_DataType::setAssessment_Status_Reference()
     * @uses Recruiting_Assessment_DataType::setOverall_Assessment_Comment()
     * @uses Recruiting_Assessment_DataType::setIs_Inline_Assessment()
     * @uses Recruiting_Assessment_DataType::setAssessment_Test_URL()
     * @uses Recruiting_Assessment_DataType::setAssess_Candidate_Test_Result_Data()
     * @param string $assess_Candidate_Reference
     * @param \StructType\WorkerObjectType $assessed_By_Reference
     * @param string $assessed_On_Date
     * @param \StructType\Recruiting_Assessment_StatusObjectType $assessment_Status_Reference
     * @param string $overall_Assessment_Comment
     * @param bool $is_Inline_Assessment
     * @param string $assessment_Test_URL
     * @param \StructType\Recruiting_Assessment_Test_Result_DataType[] $assess_Candidate_Test_Result_Data
     */
    public function __construct($assess_Candidate_Reference = null, \StructType\WorkerObjectType $assessed_By_Reference = null, $assessed_On_Date = null, \StructType\Recruiting_Assessment_StatusObjectType $assessment_Status_Reference = null, $overall_Assessment_Comment = null, $is_Inline_Assessment = null, $assessment_Test_URL = null, array $assess_Candidate_Test_Result_Data = array())
    {
        $this
            ->setAssess_Candidate_Reference($assess_Candidate_Reference)
            ->setAssessed_By_Reference($assessed_By_Reference)
            ->setAssessed_On_Date($assessed_On_Date)
            ->setAssessment_Status_Reference($assessment_Status_Reference)
            ->setOverall_Assessment_Comment($overall_Assessment_Comment)
            ->setIs_Inline_Assessment($is_Inline_Assessment)
            ->setAssessment_Test_URL($assessment_Test_URL)
            ->setAssess_Candidate_Test_Result_Data($assess_Candidate_Test_Result_Data);
    }
    /**
     * Get Assess_Candidate_Reference value
     * @return string|null
     */
    public function getAssess_Candidate_Reference()
    {
        return $this->Assess_Candidate_Reference;
    }
    /**
     * Set Assess_Candidate_Reference value
     * @param string $assess_Candidate_Reference
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssess_Candidate_Reference($assess_Candidate_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($assess_Candidate_Reference) && !is_string($assess_Candidate_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assess_Candidate_Reference, true), gettype($assess_Candidate_Reference)), __LINE__);
        }
        $this->Assess_Candidate_Reference = $assess_Candidate_Reference;
        return $this;
    }
    /**
     * Get Assessed_By_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAssessed_By_Reference()
    {
        return $this->Assessed_By_Reference;
    }
    /**
     * Set Assessed_By_Reference value
     * @param \StructType\WorkerObjectType $assessed_By_Reference
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssessed_By_Reference(\StructType\WorkerObjectType $assessed_By_Reference = null)
    {
        $this->Assessed_By_Reference = $assessed_By_Reference;
        return $this;
    }
    /**
     * Get Assessed_On_Date value
     * @return string|null
     */
    public function getAssessed_On_Date()
    {
        return $this->Assessed_On_Date;
    }
    /**
     * Set Assessed_On_Date value
     * @param string $assessed_On_Date
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssessed_On_Date($assessed_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($assessed_On_Date) && !is_string($assessed_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessed_On_Date, true), gettype($assessed_On_Date)), __LINE__);
        }
        $this->Assessed_On_Date = $assessed_On_Date;
        return $this;
    }
    /**
     * Get Assessment_Status_Reference value
     * @return \StructType\Recruiting_Assessment_StatusObjectType|null
     */
    public function getAssessment_Status_Reference()
    {
        return $this->Assessment_Status_Reference;
    }
    /**
     * Set Assessment_Status_Reference value
     * @param \StructType\Recruiting_Assessment_StatusObjectType $assessment_Status_Reference
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssessment_Status_Reference(\StructType\Recruiting_Assessment_StatusObjectType $assessment_Status_Reference = null)
    {
        $this->Assessment_Status_Reference = $assessment_Status_Reference;
        return $this;
    }
    /**
     * Get Overall_Assessment_Comment value
     * @return string|null
     */
    public function getOverall_Assessment_Comment()
    {
        return $this->Overall_Assessment_Comment;
    }
    /**
     * Set Overall_Assessment_Comment value
     * @param string $overall_Assessment_Comment
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setOverall_Assessment_Comment($overall_Assessment_Comment = null)
    {
        // validation for constraint: string
        if (!is_null($overall_Assessment_Comment) && !is_string($overall_Assessment_Comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overall_Assessment_Comment, true), gettype($overall_Assessment_Comment)), __LINE__);
        }
        $this->Overall_Assessment_Comment = $overall_Assessment_Comment;
        return $this;
    }
    /**
     * Get Is_Inline_Assessment value
     * @return bool|null
     */
    public function getIs_Inline_Assessment()
    {
        return $this->Is_Inline_Assessment;
    }
    /**
     * Set Is_Inline_Assessment value
     * @param bool $is_Inline_Assessment
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setIs_Inline_Assessment($is_Inline_Assessment = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Inline_Assessment) && !is_bool($is_Inline_Assessment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Inline_Assessment, true), gettype($is_Inline_Assessment)), __LINE__);
        }
        $this->Is_Inline_Assessment = $is_Inline_Assessment;
        return $this;
    }
    /**
     * Get Assessment_Test_URL value
     * @return string|null
     */
    public function getAssessment_Test_URL()
    {
        return $this->Assessment_Test_URL;
    }
    /**
     * Set Assessment_Test_URL value
     * @param string $assessment_Test_URL
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssessment_Test_URL($assessment_Test_URL = null)
    {
        // validation for constraint: string
        if (!is_null($assessment_Test_URL) && !is_string($assessment_Test_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessment_Test_URL, true), gettype($assessment_Test_URL)), __LINE__);
        }
        $this->Assessment_Test_URL = $assessment_Test_URL;
        return $this;
    }
    /**
     * Get Assess_Candidate_Test_Result_Data value
     * @return \StructType\Recruiting_Assessment_Test_Result_DataType[]|null
     */
    public function getAssess_Candidate_Test_Result_Data()
    {
        return $this->Assess_Candidate_Test_Result_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAssess_Candidate_Test_Result_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssess_Candidate_Test_Result_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssess_Candidate_Test_Result_DataForArrayConstraintsFromSetAssess_Candidate_Test_Result_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem instanceof \StructType\Recruiting_Assessment_Test_Result_DataType) {
                $invalidValues[] = is_object($recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem) ? get_class($recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem) : sprintf('%s(%s)', gettype($recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem), var_export($recruiting_Assessment_DataTypeAssess_Candidate_Test_Result_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assess_Candidate_Test_Result_Data property can only contain items of type \StructType\Recruiting_Assessment_Test_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Assess_Candidate_Test_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Test_Result_DataType[] $assess_Candidate_Test_Result_Data
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function setAssess_Candidate_Test_Result_Data(array $assess_Candidate_Test_Result_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($assess_Candidate_Test_Result_DataArrayErrorMessage = self::validateAssess_Candidate_Test_Result_DataForArrayConstraintsFromSetAssess_Candidate_Test_Result_Data($assess_Candidate_Test_Result_Data))) {
            throw new \InvalidArgumentException($assess_Candidate_Test_Result_DataArrayErrorMessage, __LINE__);
        }
        $this->Assess_Candidate_Test_Result_Data = $assess_Candidate_Test_Result_Data;
        return $this;
    }
    /**
     * Add item to Assess_Candidate_Test_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Test_Result_DataType $item
     * @return \StructType\Recruiting_Assessment_DataType
     */
    public function addToAssess_Candidate_Test_Result_Data(\StructType\Recruiting_Assessment_Test_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Assessment_Test_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Assess_Candidate_Test_Result_Data property can only contain items of type \StructType\Recruiting_Assessment_Test_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Assess_Candidate_Test_Result_Data[] = $item;
        return $this;
    }
}
