<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Assessment_Category_Security_Segment_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data for the Recruiting Assessment Category Security Segment.
 * @subpackage Structs
 */
class Recruiting_Assessment_Category_Security_Segment_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Assessment Category Security Segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Recruiting_Assessment_Category_Security_Segment_Name
     * Meta information extracted from the WSDL
     * - documentation: The name for the Recruiting Assessment Category Security Segment.
     * - maxOccurs: 1
     * @var string
     */
    public $Recruiting_Assessment_Category_Security_Segment_Name;
    /**
     * The Recruiting_Assessment_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Recruiting Assessment Category secured by the security segment.
     * - maxOccurs: unbounded
     * @var \StructType\Recruiting_Assessment_CategoryObjectType[]
     */
    public $Recruiting_Assessment_Category_Reference;
    /**
     * Constructor method for Recruiting_Assessment_Category_Security_Segment_DataType
     * @uses Recruiting_Assessment_Category_Security_Segment_DataType::setID()
     * @uses Recruiting_Assessment_Category_Security_Segment_DataType::setRecruiting_Assessment_Category_Security_Segment_Name()
     * @uses Recruiting_Assessment_Category_Security_Segment_DataType::setRecruiting_Assessment_Category_Reference()
     * @param string $iD
     * @param string $recruiting_Assessment_Category_Security_Segment_Name
     * @param \StructType\Recruiting_Assessment_CategoryObjectType[] $recruiting_Assessment_Category_Reference
     */
    public function __construct($iD = null, $recruiting_Assessment_Category_Security_Segment_Name = null, array $recruiting_Assessment_Category_Reference = array())
    {
        $this
            ->setID($iD)
            ->setRecruiting_Assessment_Category_Security_Segment_Name($recruiting_Assessment_Category_Security_Segment_Name)
            ->setRecruiting_Assessment_Category_Reference($recruiting_Assessment_Category_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Assessment_Category_Security_Segment_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Recruiting_Assessment_Category_Security_Segment_Name value
     * @return string|null
     */
    public function getRecruiting_Assessment_Category_Security_Segment_Name()
    {
        return $this->Recruiting_Assessment_Category_Security_Segment_Name;
    }
    /**
     * Set Recruiting_Assessment_Category_Security_Segment_Name value
     * @param string $recruiting_Assessment_Category_Security_Segment_Name
     * @return \StructType\Recruiting_Assessment_Category_Security_Segment_DataType
     */
    public function setRecruiting_Assessment_Category_Security_Segment_Name($recruiting_Assessment_Category_Security_Segment_Name = null)
    {
        // validation for constraint: string
        if (!is_null($recruiting_Assessment_Category_Security_Segment_Name) && !is_string($recruiting_Assessment_Category_Security_Segment_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recruiting_Assessment_Category_Security_Segment_Name, true), gettype($recruiting_Assessment_Category_Security_Segment_Name)), __LINE__);
        }
        $this->Recruiting_Assessment_Category_Security_Segment_Name = $recruiting_Assessment_Category_Security_Segment_Name;
        return $this;
    }
    /**
     * Get Recruiting_Assessment_Category_Reference value
     * @return \StructType\Recruiting_Assessment_CategoryObjectType[]|null
     */
    public function getRecruiting_Assessment_Category_Reference()
    {
        return $this->Recruiting_Assessment_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Assessment_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Assessment_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Assessment_Category_ReferenceForArrayConstraintsFromSetRecruiting_Assessment_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem instanceof \StructType\Recruiting_Assessment_CategoryObjectType) {
                $invalidValues[] = is_object($recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem) ? get_class($recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem), var_export($recruiting_Assessment_Category_Security_Segment_DataTypeRecruiting_Assessment_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Assessment_Category_Reference property can only contain items of type \StructType\Recruiting_Assessment_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Assessment_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_CategoryObjectType[] $recruiting_Assessment_Category_Reference
     * @return \StructType\Recruiting_Assessment_Category_Security_Segment_DataType
     */
    public function setRecruiting_Assessment_Category_Reference(array $recruiting_Assessment_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Assessment_Category_ReferenceArrayErrorMessage = self::validateRecruiting_Assessment_Category_ReferenceForArrayConstraintsFromSetRecruiting_Assessment_Category_Reference($recruiting_Assessment_Category_Reference))) {
            throw new \InvalidArgumentException($recruiting_Assessment_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Assessment_Category_Reference = $recruiting_Assessment_Category_Reference;
        return $this;
    }
    /**
     * Add item to Recruiting_Assessment_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_CategoryObjectType $item
     * @return \StructType\Recruiting_Assessment_Category_Security_Segment_DataType
     */
    public function addToRecruiting_Assessment_Category_Reference(\StructType\Recruiting_Assessment_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Assessment_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Assessment_Category_Reference property can only contain items of type \StructType\Recruiting_Assessment_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Assessment_Category_Reference[] = $item;
        return $this;
    }
}
