<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_User_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Recruiting Agency User data.
 * @subpackage Structs
 */
class Recruiting_Agency_User_Response_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_User
     * Meta information extracted from the WSDL
     * - documentation: Contains name data, contact data, recruiting data, and status data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_UserType[]
     */
    public $Recruiting_Agency_User;
    /**
     * Constructor method for Recruiting_Agency_User_Response_DataType
     * @uses Recruiting_Agency_User_Response_DataType::setRecruiting_Agency_User()
     * @param \StructType\Recruiting_Agency_UserType[] $recruiting_Agency_User
     */
    public function __construct(array $recruiting_Agency_User = array())
    {
        $this
            ->setRecruiting_Agency_User($recruiting_Agency_User);
    }
    /**
     * Get Recruiting_Agency_User value
     * @return \StructType\Recruiting_Agency_UserType[]|null
     */
    public function getRecruiting_Agency_User()
    {
        return $this->Recruiting_Agency_User;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_User method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_User method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_UserForArrayConstraintsFromSetRecruiting_Agency_User(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem instanceof \StructType\Recruiting_Agency_UserType) {
                $invalidValues[] = is_object($recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem) ? get_class($recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem) : sprintf('%s(%s)', gettype($recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem), var_export($recruiting_Agency_User_Response_DataTypeRecruiting_Agency_UserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_User property can only contain items of type \StructType\Recruiting_Agency_UserType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_User value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_UserType[] $recruiting_Agency_User
     * @return \StructType\Recruiting_Agency_User_Response_DataType
     */
    public function setRecruiting_Agency_User(array $recruiting_Agency_User = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_UserArrayErrorMessage = self::validateRecruiting_Agency_UserForArrayConstraintsFromSetRecruiting_Agency_User($recruiting_Agency_User))) {
            throw new \InvalidArgumentException($recruiting_Agency_UserArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_User = $recruiting_Agency_User;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_User value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_UserType $item
     * @return \StructType\Recruiting_Agency_User_Response_DataType
     */
    public function addToRecruiting_Agency_User(\StructType\Recruiting_Agency_UserType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_UserType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_User property can only contain items of type \StructType\Recruiting_Agency_UserType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_User[] = $item;
        return $this;
    }
}
