<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Recruiting Agency data.
 * @subpackage Structs
 */
class Recruiting_Agency_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A Recruiting Agency with that ID already exists. | Recruiting Agency reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of Job Posting Site
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Inactive type(s) can't be assigned. | Recruiting Agency Types for the specified Recruiting Agency.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_TypeObjectType[]
     */
    public $Type_Reference;
    /**
     * The Superior_Reference
     * Meta information extracted from the WSDL
     * - documentation: Superior cannot be self or subordinate. | Reference for a Recruiting Agency Site.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_SiteObjectType
     */
    public $Superior_Reference;
    /**
     * The Contact_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Contact Information Data
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Information_Data;
    /**
     * The Recruiting_Agency_Career_Site_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency Career Site Configuration Data
     * @var \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public $Recruiting_Agency_Career_Site_Configuration_Data;
    /**
     * The Recruiting_Agency_Payout_Terms_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the payout terms details for the recruiting agency.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Payout_Terms_DataType
     */
    public $Recruiting_Agency_Payout_Terms_Data;
    /**
     * The Recruiting_Agency_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency attachment information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Attachment_DataType[]
     */
    public $Recruiting_Agency_Attachment_Data;
    /**
     * Constructor method for Recruiting_Agency_DataType
     * @uses Recruiting_Agency_DataType::setID()
     * @uses Recruiting_Agency_DataType::setName()
     * @uses Recruiting_Agency_DataType::setInactive()
     * @uses Recruiting_Agency_DataType::setDescription()
     * @uses Recruiting_Agency_DataType::setType_Reference()
     * @uses Recruiting_Agency_DataType::setSuperior_Reference()
     * @uses Recruiting_Agency_DataType::setContact_Information_Data()
     * @uses Recruiting_Agency_DataType::setRecruiting_Agency_Career_Site_Configuration_Data()
     * @uses Recruiting_Agency_DataType::setRecruiting_Agency_Payout_Terms_Data()
     * @uses Recruiting_Agency_DataType::setRecruiting_Agency_Attachment_Data()
     * @param string $iD
     * @param string $name
     * @param bool $inactive
     * @param string $description
     * @param \StructType\Recruiting_Agency_TypeObjectType[] $type_Reference
     * @param \StructType\Recruiting_Agency_SiteObjectType $superior_Reference
     * @param \StructType\Contact_Information_DataType $contact_Information_Data
     * @param \StructType\Recruiting_Agency_Career_Site_Configuration_DataType $recruiting_Agency_Career_Site_Configuration_Data
     * @param \StructType\Recruiting_Agency_Payout_Terms_DataType $recruiting_Agency_Payout_Terms_Data
     * @param \StructType\Recruiting_Agency_Attachment_DataType[] $recruiting_Agency_Attachment_Data
     */
    public function __construct($iD = null, $name = null, $inactive = null, $description = null, array $type_Reference = array(), \StructType\Recruiting_Agency_SiteObjectType $superior_Reference = null, \StructType\Contact_Information_DataType $contact_Information_Data = null, \StructType\Recruiting_Agency_Career_Site_Configuration_DataType $recruiting_Agency_Career_Site_Configuration_Data = null, \StructType\Recruiting_Agency_Payout_Terms_DataType $recruiting_Agency_Payout_Terms_Data = null, array $recruiting_Agency_Attachment_Data = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setInactive($inactive)
            ->setDescription($description)
            ->setType_Reference($type_Reference)
            ->setSuperior_Reference($superior_Reference)
            ->setContact_Information_Data($contact_Information_Data)
            ->setRecruiting_Agency_Career_Site_Configuration_Data($recruiting_Agency_Career_Site_Configuration_Data)
            ->setRecruiting_Agency_Payout_Terms_Data($recruiting_Agency_Payout_Terms_Data)
            ->setRecruiting_Agency_Attachment_Data($recruiting_Agency_Attachment_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Type_Reference value
     * @return \StructType\Recruiting_Agency_TypeObjectType[]|null
     */
    public function getType_Reference()
    {
        return $this->Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setType_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateType_ReferenceForArrayConstraintsFromSetType_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_DataTypeType_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_DataTypeType_ReferenceItem instanceof \StructType\Recruiting_Agency_TypeObjectType) {
                $invalidValues[] = is_object($recruiting_Agency_DataTypeType_ReferenceItem) ? get_class($recruiting_Agency_DataTypeType_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Agency_DataTypeType_ReferenceItem), var_export($recruiting_Agency_DataTypeType_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Type_Reference property can only contain items of type \StructType\Recruiting_Agency_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_TypeObjectType[] $type_Reference
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setType_Reference(array $type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($type_ReferenceArrayErrorMessage = self::validateType_ReferenceForArrayConstraintsFromSetType_Reference($type_Reference))) {
            throw new \InvalidArgumentException($type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Type_Reference = $type_Reference;
        return $this;
    }
    /**
     * Add item to Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_TypeObjectType $item
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function addToType_Reference(\StructType\Recruiting_Agency_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Type_Reference property can only contain items of type \StructType\Recruiting_Agency_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Superior_Reference value
     * @return \StructType\Recruiting_Agency_SiteObjectType|null
     */
    public function getSuperior_Reference()
    {
        return $this->Superior_Reference;
    }
    /**
     * Set Superior_Reference value
     * @param \StructType\Recruiting_Agency_SiteObjectType $superior_Reference
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setSuperior_Reference(\StructType\Recruiting_Agency_SiteObjectType $superior_Reference = null)
    {
        $this->Superior_Reference = $superior_Reference;
        return $this;
    }
    /**
     * Get Contact_Information_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Information_Data()
    {
        return $this->Contact_Information_Data;
    }
    /**
     * Set Contact_Information_Data value
     * @param \StructType\Contact_Information_DataType $contact_Information_Data
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setContact_Information_Data(\StructType\Contact_Information_DataType $contact_Information_Data = null)
    {
        $this->Contact_Information_Data = $contact_Information_Data;
        return $this;
    }
    /**
     * Get Recruiting_Agency_Career_Site_Configuration_Data value
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType|null
     */
    public function getRecruiting_Agency_Career_Site_Configuration_Data()
    {
        return $this->Recruiting_Agency_Career_Site_Configuration_Data;
    }
    /**
     * Set Recruiting_Agency_Career_Site_Configuration_Data value
     * @param \StructType\Recruiting_Agency_Career_Site_Configuration_DataType $recruiting_Agency_Career_Site_Configuration_Data
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setRecruiting_Agency_Career_Site_Configuration_Data(\StructType\Recruiting_Agency_Career_Site_Configuration_DataType $recruiting_Agency_Career_Site_Configuration_Data = null)
    {
        $this->Recruiting_Agency_Career_Site_Configuration_Data = $recruiting_Agency_Career_Site_Configuration_Data;
        return $this;
    }
    /**
     * Get Recruiting_Agency_Payout_Terms_Data value
     * @return \StructType\Recruiting_Agency_Payout_Terms_DataType|null
     */
    public function getRecruiting_Agency_Payout_Terms_Data()
    {
        return $this->Recruiting_Agency_Payout_Terms_Data;
    }
    /**
     * Set Recruiting_Agency_Payout_Terms_Data value
     * @param \StructType\Recruiting_Agency_Payout_Terms_DataType $recruiting_Agency_Payout_Terms_Data
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setRecruiting_Agency_Payout_Terms_Data(\StructType\Recruiting_Agency_Payout_Terms_DataType $recruiting_Agency_Payout_Terms_Data = null)
    {
        $this->Recruiting_Agency_Payout_Terms_Data = $recruiting_Agency_Payout_Terms_Data;
        return $this;
    }
    /**
     * Get Recruiting_Agency_Attachment_Data value
     * @return \StructType\Recruiting_Agency_Attachment_DataType[]|null
     */
    public function getRecruiting_Agency_Attachment_Data()
    {
        return $this->Recruiting_Agency_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_Attachment_DataForArrayConstraintsFromSetRecruiting_Agency_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem instanceof \StructType\Recruiting_Agency_Attachment_DataType) {
                $invalidValues[] = is_object($recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem) ? get_class($recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem) : sprintf('%s(%s)', gettype($recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem), var_export($recruiting_Agency_DataTypeRecruiting_Agency_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Attachment_DataType[] $recruiting_Agency_Attachment_Data
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function setRecruiting_Agency_Attachment_Data(array $recruiting_Agency_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_Attachment_DataArrayErrorMessage = self::validateRecruiting_Agency_Attachment_DataForArrayConstraintsFromSetRecruiting_Agency_Attachment_Data($recruiting_Agency_Attachment_Data))) {
            throw new \InvalidArgumentException($recruiting_Agency_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_Attachment_Data = $recruiting_Agency_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Attachment_DataType $item
     * @return \StructType\Recruiting_Agency_DataType
     */
    public function addToRecruiting_Agency_Attachment_Data(\StructType\Recruiting_Agency_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_Attachment_Data[] = $item;
        return $this;
    }
}
