<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_Career_Site_Configuration_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Recruiting Agency data.
 * @subpackage Structs
 */
class Recruiting_Agency_Career_Site_Configuration_DataType extends AbstractStructBase
{
    /**
     * The Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Applicant Source Information
     * @var \StructType\Applicant_SourceObjectType
     */
    public $Source_Reference;
    /**
     * The Ownership_Period
     * Meta information extracted from the WSDL
     * - documentation: Ownership Period
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Ownership_Period;
    /**
     * The Job_Posting_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Job Posting.
     * @var \StructType\Job_Posting_TemplateObjectType
     */
    public $Job_Posting_Template_Reference;
    /**
     * The Allow_Confidential_Job_Postings
     * Meta information extracted from the WSDL
     * - documentation: Allow Confidential Job Postings
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_Confidential_Job_Postings;
    /**
     * The External_Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an External Job Posting Site
     * - minOccurs: 0
     * @var \StructType\External_Job_Posting_SiteObjectType
     */
    public $External_Job_Posting_Site_Reference;
    /**
     * The Restrict_to_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a location.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Restrict_to_Locations_Reference;
    /**
     * The Terms_and_Conditions
     * Meta information extracted from the WSDL
     * - documentation: Terms and Conditions
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Terms_and_Conditions;
    /**
     * The Require_e_signature
     * Meta information extracted from the WSDL
     * - documentation: Require e-signature
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Require_e_signature;
    /**
     * Constructor method for Recruiting_Agency_Career_Site_Configuration_DataType
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setSource_Reference()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setOwnership_Period()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setJob_Posting_Template_Reference()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setAllow_Confidential_Job_Postings()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setExternal_Job_Posting_Site_Reference()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setRestrict_to_Locations_Reference()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setTerms_and_Conditions()
     * @uses Recruiting_Agency_Career_Site_Configuration_DataType::setRequire_e_signature()
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @param float $ownership_Period
     * @param \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference
     * @param bool $allow_Confidential_Job_Postings
     * @param \StructType\External_Job_Posting_SiteObjectType $external_Job_Posting_Site_Reference
     * @param \StructType\LocationObjectType[] $restrict_to_Locations_Reference
     * @param string $terms_and_Conditions
     * @param bool $require_e_signature
     */
    public function __construct(\StructType\Applicant_SourceObjectType $source_Reference = null, $ownership_Period = null, \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference = null, $allow_Confidential_Job_Postings = null, \StructType\External_Job_Posting_SiteObjectType $external_Job_Posting_Site_Reference = null, array $restrict_to_Locations_Reference = array(), $terms_and_Conditions = null, $require_e_signature = null)
    {
        $this
            ->setSource_Reference($source_Reference)
            ->setOwnership_Period($ownership_Period)
            ->setJob_Posting_Template_Reference($job_Posting_Template_Reference)
            ->setAllow_Confidential_Job_Postings($allow_Confidential_Job_Postings)
            ->setExternal_Job_Posting_Site_Reference($external_Job_Posting_Site_Reference)
            ->setRestrict_to_Locations_Reference($restrict_to_Locations_Reference)
            ->setTerms_and_Conditions($terms_and_Conditions)
            ->setRequire_e_signature($require_e_signature);
    }
    /**
     * Get Source_Reference value
     * @return \StructType\Applicant_SourceObjectType|null
     */
    public function getSource_Reference()
    {
        return $this->Source_Reference;
    }
    /**
     * Set Source_Reference value
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setSource_Reference(\StructType\Applicant_SourceObjectType $source_Reference = null)
    {
        $this->Source_Reference = $source_Reference;
        return $this;
    }
    /**
     * Get Ownership_Period value
     * @return float|null
     */
    public function getOwnership_Period()
    {
        return $this->Ownership_Period;
    }
    /**
     * Set Ownership_Period value
     * @param float $ownership_Period
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setOwnership_Period($ownership_Period = null)
    {
        // validation for constraint: float
        if (!is_null($ownership_Period) && !(is_float($ownership_Period) || is_numeric($ownership_Period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownership_Period, true), gettype($ownership_Period)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($ownership_Period) && mb_strlen(mb_substr($ownership_Period, false !== mb_strpos($ownership_Period, '.') ? mb_strpos($ownership_Period, '.') + 1 : mb_strlen($ownership_Period))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($ownership_Period, true), mb_strlen(mb_substr($ownership_Period, mb_strpos($ownership_Period, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ownership_Period) && $ownership_Period < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ownership_Period, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($ownership_Period) && mb_strlen(preg_replace('/(\D)/', '', $ownership_Period)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($ownership_Period, true), mb_strlen(preg_replace('/(\D)/', '', $ownership_Period))), __LINE__);
        }
        $this->Ownership_Period = $ownership_Period;
        return $this;
    }
    /**
     * Get Job_Posting_Template_Reference value
     * @return \StructType\Job_Posting_TemplateObjectType|null
     */
    public function getJob_Posting_Template_Reference()
    {
        return $this->Job_Posting_Template_Reference;
    }
    /**
     * Set Job_Posting_Template_Reference value
     * @param \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setJob_Posting_Template_Reference(\StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference = null)
    {
        $this->Job_Posting_Template_Reference = $job_Posting_Template_Reference;
        return $this;
    }
    /**
     * Get Allow_Confidential_Job_Postings value
     * @return bool|null
     */
    public function getAllow_Confidential_Job_Postings()
    {
        return $this->Allow_Confidential_Job_Postings;
    }
    /**
     * Set Allow_Confidential_Job_Postings value
     * @param bool $allow_Confidential_Job_Postings
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setAllow_Confidential_Job_Postings($allow_Confidential_Job_Postings = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_Confidential_Job_Postings) && !is_bool($allow_Confidential_Job_Postings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_Confidential_Job_Postings, true), gettype($allow_Confidential_Job_Postings)), __LINE__);
        }
        $this->Allow_Confidential_Job_Postings = $allow_Confidential_Job_Postings;
        return $this;
    }
    /**
     * Get External_Job_Posting_Site_Reference value
     * @return \StructType\External_Job_Posting_SiteObjectType|null
     */
    public function getExternal_Job_Posting_Site_Reference()
    {
        return $this->External_Job_Posting_Site_Reference;
    }
    /**
     * Set External_Job_Posting_Site_Reference value
     * @param \StructType\External_Job_Posting_SiteObjectType $external_Job_Posting_Site_Reference
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setExternal_Job_Posting_Site_Reference(\StructType\External_Job_Posting_SiteObjectType $external_Job_Posting_Site_Reference = null)
    {
        $this->External_Job_Posting_Site_Reference = $external_Job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Get Restrict_to_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getRestrict_to_Locations_Reference()
    {
        return $this->Restrict_to_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrict_to_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrict_to_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrict_to_Locations_ReferenceForArrayConstraintsFromSetRestrict_to_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem) ? get_class($recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem), var_export($recruiting_Agency_Career_Site_Configuration_DataTypeRestrict_to_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restrict_to_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restrict_to_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $restrict_to_Locations_Reference
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setRestrict_to_Locations_Reference(array $restrict_to_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restrict_to_Locations_ReferenceArrayErrorMessage = self::validateRestrict_to_Locations_ReferenceForArrayConstraintsFromSetRestrict_to_Locations_Reference($restrict_to_Locations_Reference))) {
            throw new \InvalidArgumentException($restrict_to_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restrict_to_Locations_Reference = $restrict_to_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Restrict_to_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function addToRestrict_to_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restrict_to_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restrict_to_Locations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Terms_and_Conditions value
     * @return string|null
     */
    public function getTerms_and_Conditions()
    {
        return $this->Terms_and_Conditions;
    }
    /**
     * Set Terms_and_Conditions value
     * @param string $terms_and_Conditions
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setTerms_and_Conditions($terms_and_Conditions = null)
    {
        // validation for constraint: string
        if (!is_null($terms_and_Conditions) && !is_string($terms_and_Conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terms_and_Conditions, true), gettype($terms_and_Conditions)), __LINE__);
        }
        $this->Terms_and_Conditions = $terms_and_Conditions;
        return $this;
    }
    /**
     * Get Require_e_signature value
     * @return bool|null
     */
    public function getRequire_e_signature()
    {
        return $this->{'Require_e-signature'};
    }
    /**
     * Set Require_e_signature value
     * @param bool $require_e_signature
     * @return \StructType\Recruiting_Agency_Career_Site_Configuration_DataType
     */
    public function setRequire_e_signature($require_e_signature = null)
    {
        // validation for constraint: boolean
        if (!is_null($require_e_signature) && !is_bool($require_e_signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($require_e_signature, true), gettype($require_e_signature)), __LINE__);
        }
        $this->Require_e_signature = $this->{'Require_e-signature'} = $require_e_signature;
        return $this;
    }
}
