<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_Candidate_Submission_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Candidate Submission data for recruiting agency candidate process.
 * @subpackage Structs
 */
class Recruiting_Agency_Candidate_Submission_DataType extends AbstractStructBase
{
    /**
     * The Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Recruiting Agency Site.
     * @var \StructType\Recruiting_Agency_SiteObjectType
     */
    public $Agency_Reference;
    /**
     * The Agency_User_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Recruiting Agency User.
     * @var \StructType\Recruiting_Agency_UserObjectType
     */
    public $Agency_User_Reference;
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Job Posting.
     * - minOccurs: 0
     * @var \StructType\Job_PostingObjectType
     */
    public $Job_Posting_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Candidate_Name_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Name_DataType
     */
    public $Candidate_Name_Data;
    /**
     * The Candidate_Contact_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Contact_DataType
     */
    public $Candidate_Contact_Data;
    /**
     * The Candidate_Social_Media_Account_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Social_Media_Account_DataType[]
     */
    public $Candidate_Social_Media_Account_Data;
    /**
     * The Candidate_Resume_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Resume_DataType
     */
    public $Candidate_Resume_Data;
    /**
     * The Candidate_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Candidate_Attachment_DataType[]
     */
    public $Candidate_Attachment_Data;
    /**
     * Constructor method for Recruiting_Agency_Candidate_Submission_DataType
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setAgency_Reference()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setAgency_User_Reference()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setJob_Posting_Reference()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setJob_Requisition_Reference()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setCandidate_Name_Data()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setCandidate_Contact_Data()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setCandidate_Social_Media_Account_Data()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setCandidate_Resume_Data()
     * @uses Recruiting_Agency_Candidate_Submission_DataType::setCandidate_Attachment_Data()
     * @param \StructType\Recruiting_Agency_SiteObjectType $agency_Reference
     * @param \StructType\Recruiting_Agency_UserObjectType $agency_User_Reference
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Candidate_Name_DataType $candidate_Name_Data
     * @param \StructType\Candidate_Contact_DataType $candidate_Contact_Data
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $candidate_Social_Media_Account_Data
     * @param \StructType\Candidate_Resume_DataType $candidate_Resume_Data
     * @param \StructType\Recruiting_Agency_Candidate_Attachment_DataType[] $candidate_Attachment_Data
     */
    public function __construct(\StructType\Recruiting_Agency_SiteObjectType $agency_Reference = null, \StructType\Recruiting_Agency_UserObjectType $agency_User_Reference = null, \StructType\Job_PostingObjectType $job_Posting_Reference = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Candidate_Name_DataType $candidate_Name_Data = null, \StructType\Candidate_Contact_DataType $candidate_Contact_Data = null, array $candidate_Social_Media_Account_Data = array(), \StructType\Candidate_Resume_DataType $candidate_Resume_Data = null, array $candidate_Attachment_Data = array())
    {
        $this
            ->setAgency_Reference($agency_Reference)
            ->setAgency_User_Reference($agency_User_Reference)
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setCandidate_Name_Data($candidate_Name_Data)
            ->setCandidate_Contact_Data($candidate_Contact_Data)
            ->setCandidate_Social_Media_Account_Data($candidate_Social_Media_Account_Data)
            ->setCandidate_Resume_Data($candidate_Resume_Data)
            ->setCandidate_Attachment_Data($candidate_Attachment_Data);
    }
    /**
     * Get Agency_Reference value
     * @return \StructType\Recruiting_Agency_SiteObjectType|null
     */
    public function getAgency_Reference()
    {
        return $this->Agency_Reference;
    }
    /**
     * Set Agency_Reference value
     * @param \StructType\Recruiting_Agency_SiteObjectType $agency_Reference
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setAgency_Reference(\StructType\Recruiting_Agency_SiteObjectType $agency_Reference = null)
    {
        $this->Agency_Reference = $agency_Reference;
        return $this;
    }
    /**
     * Get Agency_User_Reference value
     * @return \StructType\Recruiting_Agency_UserObjectType|null
     */
    public function getAgency_User_Reference()
    {
        return $this->Agency_User_Reference;
    }
    /**
     * Set Agency_User_Reference value
     * @param \StructType\Recruiting_Agency_UserObjectType $agency_User_Reference
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setAgency_User_Reference(\StructType\Recruiting_Agency_UserObjectType $agency_User_Reference = null)
    {
        $this->Agency_User_Reference = $agency_User_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType|null
     */
    public function getJob_Posting_Reference()
    {
        return $this->Job_Posting_Reference;
    }
    /**
     * Set Job_Posting_Reference value
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setJob_Posting_Reference(\StructType\Job_PostingObjectType $job_Posting_Reference = null)
    {
        $this->Job_Posting_Reference = $job_Posting_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Candidate_Name_Data value
     * @return \StructType\Candidate_Name_DataType|null
     */
    public function getCandidate_Name_Data()
    {
        return $this->Candidate_Name_Data;
    }
    /**
     * Set Candidate_Name_Data value
     * @param \StructType\Candidate_Name_DataType $candidate_Name_Data
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setCandidate_Name_Data(\StructType\Candidate_Name_DataType $candidate_Name_Data = null)
    {
        $this->Candidate_Name_Data = $candidate_Name_Data;
        return $this;
    }
    /**
     * Get Candidate_Contact_Data value
     * @return \StructType\Candidate_Contact_DataType|null
     */
    public function getCandidate_Contact_Data()
    {
        return $this->Candidate_Contact_Data;
    }
    /**
     * Set Candidate_Contact_Data value
     * @param \StructType\Candidate_Contact_DataType $candidate_Contact_Data
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setCandidate_Contact_Data(\StructType\Candidate_Contact_DataType $candidate_Contact_Data = null)
    {
        $this->Candidate_Contact_Data = $candidate_Contact_Data;
        return $this;
    }
    /**
     * Get Candidate_Social_Media_Account_Data value
     * @return \StructType\Candidate_Social_Media_Account_DataType[]|null
     */
    public function getCandidate_Social_Media_Account_Data()
    {
        return $this->Candidate_Social_Media_Account_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Social_Media_Account_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Social_Media_Account_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Social_Media_Account_DataForArrayConstraintsFromSetCandidate_Social_Media_Account_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem instanceof \StructType\Candidate_Social_Media_Account_DataType) {
                $invalidValues[] = is_object($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem) ? get_class($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem) : sprintf('%s(%s)', gettype($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem), var_export($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Social_Media_Account_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $candidate_Social_Media_Account_Data
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setCandidate_Social_Media_Account_Data(array $candidate_Social_Media_Account_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Social_Media_Account_DataArrayErrorMessage = self::validateCandidate_Social_Media_Account_DataForArrayConstraintsFromSetCandidate_Social_Media_Account_Data($candidate_Social_Media_Account_Data))) {
            throw new \InvalidArgumentException($candidate_Social_Media_Account_DataArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Social_Media_Account_Data = $candidate_Social_Media_Account_Data;
        return $this;
    }
    /**
     * Add item to Candidate_Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType $item
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function addToCandidate_Social_Media_Account_Data(\StructType\Candidate_Social_Media_Account_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Social_Media_Account_DataType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Social_Media_Account_Data[] = $item;
        return $this;
    }
    /**
     * Get Candidate_Resume_Data value
     * @return \StructType\Candidate_Resume_DataType|null
     */
    public function getCandidate_Resume_Data()
    {
        return $this->Candidate_Resume_Data;
    }
    /**
     * Set Candidate_Resume_Data value
     * @param \StructType\Candidate_Resume_DataType $candidate_Resume_Data
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setCandidate_Resume_Data(\StructType\Candidate_Resume_DataType $candidate_Resume_Data = null)
    {
        $this->Candidate_Resume_Data = $candidate_Resume_Data;
        return $this;
    }
    /**
     * Get Candidate_Attachment_Data value
     * @return \StructType\Recruiting_Agency_Candidate_Attachment_DataType[]|null
     */
    public function getCandidate_Attachment_Data()
    {
        return $this->Candidate_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Attachment_DataForArrayConstraintsFromSetCandidate_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem instanceof \StructType\Recruiting_Agency_Candidate_Attachment_DataType) {
                $invalidValues[] = is_object($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem) ? get_class($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem) : sprintf('%s(%s)', gettype($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem), var_export($recruiting_Agency_Candidate_Submission_DataTypeCandidate_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_Candidate_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Candidate_Attachment_DataType[] $candidate_Attachment_Data
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function setCandidate_Attachment_Data(array $candidate_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Attachment_DataArrayErrorMessage = self::validateCandidate_Attachment_DataForArrayConstraintsFromSetCandidate_Attachment_Data($candidate_Attachment_Data))) {
            throw new \InvalidArgumentException($candidate_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Attachment_Data = $candidate_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Candidate_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Candidate_Attachment_DataType $item
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public function addToCandidate_Attachment_Data(\StructType\Recruiting_Agency_Candidate_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_Candidate_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_Candidate_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Attachment_Data[] = $item;
        return $this;
    }
}
