<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaires_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the questionnaire response.
 * @subpackage Structs
 */
class Questionnaires_Response_DataType extends AbstractStructBase
{
    /**
     * The Questionnaire_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the questionnaire for questionnaire response.
     * @var \StructType\QuestionnaireObjectType
     */
    public $Questionnaire_Reference;
    /**
     * The Questionnaire_Answer_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Questionnaire_Answer_DataType[]
     */
    public $Questionnaire_Answer_Data;
    /**
     * Constructor method for Questionnaires_Response_DataType
     * @uses Questionnaires_Response_DataType::setQuestionnaire_Reference()
     * @uses Questionnaires_Response_DataType::setQuestionnaire_Answer_Data()
     * @param \StructType\QuestionnaireObjectType $questionnaire_Reference
     * @param \StructType\Questionnaire_Answer_DataType[] $questionnaire_Answer_Data
     */
    public function __construct(\StructType\QuestionnaireObjectType $questionnaire_Reference = null, array $questionnaire_Answer_Data = array())
    {
        $this
            ->setQuestionnaire_Reference($questionnaire_Reference)
            ->setQuestionnaire_Answer_Data($questionnaire_Answer_Data);
    }
    /**
     * Get Questionnaire_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getQuestionnaire_Reference()
    {
        return $this->Questionnaire_Reference;
    }
    /**
     * Set Questionnaire_Reference value
     * @param \StructType\QuestionnaireObjectType $questionnaire_Reference
     * @return \StructType\Questionnaires_Response_DataType
     */
    public function setQuestionnaire_Reference(\StructType\QuestionnaireObjectType $questionnaire_Reference = null)
    {
        $this->Questionnaire_Reference = $questionnaire_Reference;
        return $this;
    }
    /**
     * Get Questionnaire_Answer_Data value
     * @return \StructType\Questionnaire_Answer_DataType[]|null
     */
    public function getQuestionnaire_Answer_Data()
    {
        return $this->Questionnaire_Answer_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaire_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaire_Answer_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaire_Answer_DataForArrayConstraintsFromSetQuestionnaire_Answer_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem) {
            // validation for constraint: itemType
            if (!$questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem instanceof \StructType\Questionnaire_Answer_DataType) {
                $invalidValues[] = is_object($questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem) ? get_class($questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem) : sprintf('%s(%s)', gettype($questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem), var_export($questionnaires_Response_DataTypeQuestionnaire_Answer_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaire_Answer_Data property can only contain items of type \StructType\Questionnaire_Answer_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaire_Answer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Answer_DataType[] $questionnaire_Answer_Data
     * @return \StructType\Questionnaires_Response_DataType
     */
    public function setQuestionnaire_Answer_Data(array $questionnaire_Answer_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaire_Answer_DataArrayErrorMessage = self::validateQuestionnaire_Answer_DataForArrayConstraintsFromSetQuestionnaire_Answer_Data($questionnaire_Answer_Data))) {
            throw new \InvalidArgumentException($questionnaire_Answer_DataArrayErrorMessage, __LINE__);
        }
        $this->Questionnaire_Answer_Data = $questionnaire_Answer_Data;
        return $this;
    }
    /**
     * Add item to Questionnaire_Answer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Answer_DataType $item
     * @return \StructType\Questionnaires_Response_DataType
     */
    public function addToQuestionnaire_Answer_Data(\StructType\Questionnaire_Answer_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Questionnaire_Answer_DataType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaire_Answer_Data property can only contain items of type \StructType\Questionnaire_Answer_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaire_Answer_Data[] = $item;
        return $this;
    }
}
