<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaire_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Retrieves questionnaires by reference or Workday ID.
 * @subpackage Structs
 */
class Questionnaire_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Questionnaire_Reference
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire reference.
     * - maxOccurs: unbounded
     * @var \StructType\QuestionnaireObjectType[]
     */
    public $Questionnaire_Reference;
    /**
     * Constructor method for Questionnaire_Request_ReferencesType
     * @uses Questionnaire_Request_ReferencesType::setQuestionnaire_Reference()
     * @param \StructType\QuestionnaireObjectType[] $questionnaire_Reference
     */
    public function __construct(array $questionnaire_Reference = array())
    {
        $this
            ->setQuestionnaire_Reference($questionnaire_Reference);
    }
    /**
     * Get Questionnaire_Reference value
     * @return \StructType\QuestionnaireObjectType[]|null
     */
    public function getQuestionnaire_Reference()
    {
        return $this->Questionnaire_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaire_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaire_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaire_ReferenceForArrayConstraintsFromSetQuestionnaire_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem) {
            // validation for constraint: itemType
            if (!$questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem instanceof \StructType\QuestionnaireObjectType) {
                $invalidValues[] = is_object($questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem) ? get_class($questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem) : sprintf('%s(%s)', gettype($questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem), var_export($questionnaire_Request_ReferencesTypeQuestionnaire_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaire_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaire_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType[] $questionnaire_Reference
     * @return \StructType\Questionnaire_Request_ReferencesType
     */
    public function setQuestionnaire_Reference(array $questionnaire_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaire_ReferenceArrayErrorMessage = self::validateQuestionnaire_ReferenceForArrayConstraintsFromSetQuestionnaire_Reference($questionnaire_Reference))) {
            throw new \InvalidArgumentException($questionnaire_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Questionnaire_Reference = $questionnaire_Reference;
        return $this;
    }
    /**
     * Add item to Questionnaire_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType $item
     * @return \StructType\Questionnaire_Request_ReferencesType
     */
    public function addToQuestionnaire_Reference(\StructType\QuestionnaireObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionnaireObjectType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaire_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaire_Reference[] = $item;
        return $this;
    }
}
