<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaire_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data within a questionnaire.
 * @subpackage Structs
 */
class Questionnaire_DataType extends AbstractStructBase
{
    /**
     * The Questionnaire_ID
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Questionnaire_ID;
    /**
     * The Questionnaire_Name
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire name.
     * - maxOccurs: 1
     * @var string
     */
    public $Questionnaire_Name;
    /**
     * The Questionnaire_Display_Name
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire display name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Questionnaire_Display_Name;
    /**
     * The Questionnaire_Instructions
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire instructions.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Questionnaire_Instructions;
    /**
     * The Questionnaire_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The questionnaire type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Questionnaire_Configuration_TypeObjectType[]
     */
    public $Questionnaire_Type_Reference;
    /**
     * The Business_Process_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The business process type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Process_TypeObjectType[]
     */
    public $Business_Process_Type_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean determining if the questionnaire is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Questions_for_Questionnaire_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Questions_for_Questionnaire_DataType[]
     */
    public $Questions_for_Questionnaire_Data;
    /**
     * Constructor method for Questionnaire_DataType
     * @uses Questionnaire_DataType::setQuestionnaire_ID()
     * @uses Questionnaire_DataType::setQuestionnaire_Name()
     * @uses Questionnaire_DataType::setQuestionnaire_Display_Name()
     * @uses Questionnaire_DataType::setQuestionnaire_Instructions()
     * @uses Questionnaire_DataType::setQuestionnaire_Type_Reference()
     * @uses Questionnaire_DataType::setBusiness_Process_Type_Reference()
     * @uses Questionnaire_DataType::setInactive()
     * @uses Questionnaire_DataType::setQuestions_for_Questionnaire_Data()
     * @param string $questionnaire_ID
     * @param string $questionnaire_Name
     * @param string $questionnaire_Display_Name
     * @param string $questionnaire_Instructions
     * @param \StructType\Questionnaire_Configuration_TypeObjectType[] $questionnaire_Type_Reference
     * @param \StructType\Business_Process_TypeObjectType[] $business_Process_Type_Reference
     * @param bool $inactive
     * @param \StructType\Questions_for_Questionnaire_DataType[] $questions_for_Questionnaire_Data
     */
    public function __construct($questionnaire_ID = null, $questionnaire_Name = null, $questionnaire_Display_Name = null, $questionnaire_Instructions = null, array $questionnaire_Type_Reference = array(), array $business_Process_Type_Reference = array(), $inactive = null, array $questions_for_Questionnaire_Data = array())
    {
        $this
            ->setQuestionnaire_ID($questionnaire_ID)
            ->setQuestionnaire_Name($questionnaire_Name)
            ->setQuestionnaire_Display_Name($questionnaire_Display_Name)
            ->setQuestionnaire_Instructions($questionnaire_Instructions)
            ->setQuestionnaire_Type_Reference($questionnaire_Type_Reference)
            ->setBusiness_Process_Type_Reference($business_Process_Type_Reference)
            ->setInactive($inactive)
            ->setQuestions_for_Questionnaire_Data($questions_for_Questionnaire_Data);
    }
    /**
     * Get Questionnaire_ID value
     * @return string|null
     */
    public function getQuestionnaire_ID()
    {
        return $this->Questionnaire_ID;
    }
    /**
     * Set Questionnaire_ID value
     * @param string $questionnaire_ID
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestionnaire_ID($questionnaire_ID = null)
    {
        // validation for constraint: string
        if (!is_null($questionnaire_ID) && !is_string($questionnaire_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionnaire_ID, true), gettype($questionnaire_ID)), __LINE__);
        }
        $this->Questionnaire_ID = $questionnaire_ID;
        return $this;
    }
    /**
     * Get Questionnaire_Name value
     * @return string|null
     */
    public function getQuestionnaire_Name()
    {
        return $this->Questionnaire_Name;
    }
    /**
     * Set Questionnaire_Name value
     * @param string $questionnaire_Name
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestionnaire_Name($questionnaire_Name = null)
    {
        // validation for constraint: string
        if (!is_null($questionnaire_Name) && !is_string($questionnaire_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionnaire_Name, true), gettype($questionnaire_Name)), __LINE__);
        }
        $this->Questionnaire_Name = $questionnaire_Name;
        return $this;
    }
    /**
     * Get Questionnaire_Display_Name value
     * @return string|null
     */
    public function getQuestionnaire_Display_Name()
    {
        return $this->Questionnaire_Display_Name;
    }
    /**
     * Set Questionnaire_Display_Name value
     * @param string $questionnaire_Display_Name
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestionnaire_Display_Name($questionnaire_Display_Name = null)
    {
        // validation for constraint: string
        if (!is_null($questionnaire_Display_Name) && !is_string($questionnaire_Display_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionnaire_Display_Name, true), gettype($questionnaire_Display_Name)), __LINE__);
        }
        $this->Questionnaire_Display_Name = $questionnaire_Display_Name;
        return $this;
    }
    /**
     * Get Questionnaire_Instructions value
     * @return string|null
     */
    public function getQuestionnaire_Instructions()
    {
        return $this->Questionnaire_Instructions;
    }
    /**
     * Set Questionnaire_Instructions value
     * @param string $questionnaire_Instructions
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestionnaire_Instructions($questionnaire_Instructions = null)
    {
        // validation for constraint: string
        if (!is_null($questionnaire_Instructions) && !is_string($questionnaire_Instructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionnaire_Instructions, true), gettype($questionnaire_Instructions)), __LINE__);
        }
        $this->Questionnaire_Instructions = $questionnaire_Instructions;
        return $this;
    }
    /**
     * Get Questionnaire_Type_Reference value
     * @return \StructType\Questionnaire_Configuration_TypeObjectType[]|null
     */
    public function getQuestionnaire_Type_Reference()
    {
        return $this->Questionnaire_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaire_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaire_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaire_Type_ReferenceForArrayConstraintsFromSetQuestionnaire_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_DataTypeQuestionnaire_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$questionnaire_DataTypeQuestionnaire_Type_ReferenceItem instanceof \StructType\Questionnaire_Configuration_TypeObjectType) {
                $invalidValues[] = is_object($questionnaire_DataTypeQuestionnaire_Type_ReferenceItem) ? get_class($questionnaire_DataTypeQuestionnaire_Type_ReferenceItem) : sprintf('%s(%s)', gettype($questionnaire_DataTypeQuestionnaire_Type_ReferenceItem), var_export($questionnaire_DataTypeQuestionnaire_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaire_Type_Reference property can only contain items of type \StructType\Questionnaire_Configuration_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaire_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Configuration_TypeObjectType[] $questionnaire_Type_Reference
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestionnaire_Type_Reference(array $questionnaire_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaire_Type_ReferenceArrayErrorMessage = self::validateQuestionnaire_Type_ReferenceForArrayConstraintsFromSetQuestionnaire_Type_Reference($questionnaire_Type_Reference))) {
            throw new \InvalidArgumentException($questionnaire_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Questionnaire_Type_Reference = $questionnaire_Type_Reference;
        return $this;
    }
    /**
     * Add item to Questionnaire_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Configuration_TypeObjectType $item
     * @return \StructType\Questionnaire_DataType
     */
    public function addToQuestionnaire_Type_Reference(\StructType\Questionnaire_Configuration_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Questionnaire_Configuration_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaire_Type_Reference property can only contain items of type \StructType\Questionnaire_Configuration_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaire_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Business_Process_Type_Reference value
     * @return \StructType\Business_Process_TypeObjectType[]|null
     */
    public function getBusiness_Process_Type_Reference()
    {
        return $this->Business_Process_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_Type_ReferenceForArrayConstraintsFromSetBusiness_Process_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_DataTypeBusiness_Process_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$questionnaire_DataTypeBusiness_Process_Type_ReferenceItem instanceof \StructType\Business_Process_TypeObjectType) {
                $invalidValues[] = is_object($questionnaire_DataTypeBusiness_Process_Type_ReferenceItem) ? get_class($questionnaire_DataTypeBusiness_Process_Type_ReferenceItem) : sprintf('%s(%s)', gettype($questionnaire_DataTypeBusiness_Process_Type_ReferenceItem), var_export($questionnaire_DataTypeBusiness_Process_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Type_Reference property can only contain items of type \StructType\Business_Process_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Process_TypeObjectType[] $business_Process_Type_Reference
     * @return \StructType\Questionnaire_DataType
     */
    public function setBusiness_Process_Type_Reference(array $business_Process_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_Type_ReferenceArrayErrorMessage = self::validateBusiness_Process_Type_ReferenceForArrayConstraintsFromSetBusiness_Process_Type_Reference($business_Process_Type_Reference))) {
            throw new \InvalidArgumentException($business_Process_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Type_Reference = $business_Process_Type_Reference;
        return $this;
    }
    /**
     * Add item to Business_Process_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Process_TypeObjectType $item
     * @return \StructType\Questionnaire_DataType
     */
    public function addToBusiness_Process_Type_Reference(\StructType\Business_Process_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Process_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Type_Reference property can only contain items of type \StructType\Business_Process_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Questionnaire_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Questions_for_Questionnaire_Data value
     * @return \StructType\Questions_for_Questionnaire_DataType[]|null
     */
    public function getQuestions_for_Questionnaire_Data()
    {
        return $this->Questions_for_Questionnaire_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestions_for_Questionnaire_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestions_for_Questionnaire_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestions_for_Questionnaire_DataForArrayConstraintsFromSetQuestions_for_Questionnaire_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_DataTypeQuestions_for_Questionnaire_DataItem) {
            // validation for constraint: itemType
            if (!$questionnaire_DataTypeQuestions_for_Questionnaire_DataItem instanceof \StructType\Questions_for_Questionnaire_DataType) {
                $invalidValues[] = is_object($questionnaire_DataTypeQuestions_for_Questionnaire_DataItem) ? get_class($questionnaire_DataTypeQuestions_for_Questionnaire_DataItem) : sprintf('%s(%s)', gettype($questionnaire_DataTypeQuestions_for_Questionnaire_DataItem), var_export($questionnaire_DataTypeQuestions_for_Questionnaire_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questions_for_Questionnaire_Data property can only contain items of type \StructType\Questions_for_Questionnaire_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questions_for_Questionnaire_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Questions_for_Questionnaire_DataType[] $questions_for_Questionnaire_Data
     * @return \StructType\Questionnaire_DataType
     */
    public function setQuestions_for_Questionnaire_Data(array $questions_for_Questionnaire_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($questions_for_Questionnaire_DataArrayErrorMessage = self::validateQuestions_for_Questionnaire_DataForArrayConstraintsFromSetQuestions_for_Questionnaire_Data($questions_for_Questionnaire_Data))) {
            throw new \InvalidArgumentException($questions_for_Questionnaire_DataArrayErrorMessage, __LINE__);
        }
        $this->Questions_for_Questionnaire_Data = $questions_for_Questionnaire_Data;
        return $this;
    }
    /**
     * Add item to Questions_for_Questionnaire_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Questions_for_Questionnaire_DataType $item
     * @return \StructType\Questionnaire_DataType
     */
    public function addToQuestions_for_Questionnaire_Data(\StructType\Questions_for_Questionnaire_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Questions_for_Questionnaire_DataType) {
            throw new \InvalidArgumentException(sprintf('The Questions_for_Questionnaire_Data property can only contain items of type \StructType\Questions_for_Questionnaire_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questions_for_Questionnaire_Data[] = $item;
        return $this;
    }
}
