<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Web_Conference_Interview_Data_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains interview data for the web conference.
 * @subpackage Structs
 */
class Put_Web_Conference_Interview_Data_ResponseType extends AbstractStructBase
{
    /**
     * The Schedule_Snapshot_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Schedule Snapshot where the Put Web Conference Interview Data web service updates the Interview Custom Integration event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Schedule_Snapshot_Reference;
    /**
     * The Interview_Custom_Integration_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Interview Custom Integration Event where Put Web Conference Interview Data web service saves the Web Conference Meeting ID/URL.
     * - minOccurs: 0
     * @var \StructType\Interview_Custom_Integration_EventObjectType
     */
    public $Interview_Custom_Integration_Event_Reference;
    /**
     * The Web_Conference_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The web conference meeting ID that the Put Web Conference Interview Data web service saves to the Interview Custom Integration event.
     * - minOccurs: 0
     * @var string
     */
    public $Web_Conference_ID_Reference;
    /**
     * The Web_Conference_URL_Reference
     * Meta information extracted from the WSDL
     * - documentation: The web conference URL that the Put Web Conference Interview Data web service saves to the Interview Custom Integration event.
     * - minOccurs: 0
     * @var string
     */
    public $Web_Conference_URL_Reference;
    /**
     * The Warning_Message_Reference
     * Meta information extracted from the WSDL
     * - documentation: A warning message that the Interview Custom Integration Event isn't the latest for the Schedule Snapshot.
     * - minOccurs: 0
     * @var string
     */
    public $Warning_Message_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Web_Conference_Interview_Data_ResponseType
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setSchedule_Snapshot_Reference()
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setInterview_Custom_Integration_Event_Reference()
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setWeb_Conference_ID_Reference()
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setWeb_Conference_URL_Reference()
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setWarning_Message_Reference()
     * @uses Put_Web_Conference_Interview_Data_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $schedule_Snapshot_Reference
     * @param \StructType\Interview_Custom_Integration_EventObjectType $interview_Custom_Integration_Event_Reference
     * @param string $web_Conference_ID_Reference
     * @param string $web_Conference_URL_Reference
     * @param string $warning_Message_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $schedule_Snapshot_Reference = null, \StructType\Interview_Custom_Integration_EventObjectType $interview_Custom_Integration_Event_Reference = null, $web_Conference_ID_Reference = null, $web_Conference_URL_Reference = null, $warning_Message_Reference = null, $version = null)
    {
        $this
            ->setSchedule_Snapshot_Reference($schedule_Snapshot_Reference)
            ->setInterview_Custom_Integration_Event_Reference($interview_Custom_Integration_Event_Reference)
            ->setWeb_Conference_ID_Reference($web_Conference_ID_Reference)
            ->setWeb_Conference_URL_Reference($web_Conference_URL_Reference)
            ->setWarning_Message_Reference($warning_Message_Reference)
            ->setVersion($version);
    }
    /**
     * Get Schedule_Snapshot_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getSchedule_Snapshot_Reference()
    {
        return $this->Schedule_Snapshot_Reference;
    }
    /**
     * Set Schedule_Snapshot_Reference value
     * @param \StructType\Unique_IdentifierObjectType $schedule_Snapshot_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setSchedule_Snapshot_Reference(\StructType\Unique_IdentifierObjectType $schedule_Snapshot_Reference = null)
    {
        $this->Schedule_Snapshot_Reference = $schedule_Snapshot_Reference;
        return $this;
    }
    /**
     * Get Interview_Custom_Integration_Event_Reference value
     * @return \StructType\Interview_Custom_Integration_EventObjectType|null
     */
    public function getInterview_Custom_Integration_Event_Reference()
    {
        return $this->Interview_Custom_Integration_Event_Reference;
    }
    /**
     * Set Interview_Custom_Integration_Event_Reference value
     * @param \StructType\Interview_Custom_Integration_EventObjectType $interview_Custom_Integration_Event_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setInterview_Custom_Integration_Event_Reference(\StructType\Interview_Custom_Integration_EventObjectType $interview_Custom_Integration_Event_Reference = null)
    {
        $this->Interview_Custom_Integration_Event_Reference = $interview_Custom_Integration_Event_Reference;
        return $this;
    }
    /**
     * Get Web_Conference_ID_Reference value
     * @return string|null
     */
    public function getWeb_Conference_ID_Reference()
    {
        return $this->Web_Conference_ID_Reference;
    }
    /**
     * Set Web_Conference_ID_Reference value
     * @param string $web_Conference_ID_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setWeb_Conference_ID_Reference($web_Conference_ID_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_ID_Reference) && !is_string($web_Conference_ID_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_ID_Reference, true), gettype($web_Conference_ID_Reference)), __LINE__);
        }
        $this->Web_Conference_ID_Reference = $web_Conference_ID_Reference;
        return $this;
    }
    /**
     * Get Web_Conference_URL_Reference value
     * @return string|null
     */
    public function getWeb_Conference_URL_Reference()
    {
        return $this->Web_Conference_URL_Reference;
    }
    /**
     * Set Web_Conference_URL_Reference value
     * @param string $web_Conference_URL_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setWeb_Conference_URL_Reference($web_Conference_URL_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_URL_Reference) && !is_string($web_Conference_URL_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_URL_Reference, true), gettype($web_Conference_URL_Reference)), __LINE__);
        }
        $this->Web_Conference_URL_Reference = $web_Conference_URL_Reference;
        return $this;
    }
    /**
     * Get Warning_Message_Reference value
     * @return string|null
     */
    public function getWarning_Message_Reference()
    {
        return $this->Warning_Message_Reference;
    }
    /**
     * Set Warning_Message_Reference value
     * @param string $warning_Message_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setWarning_Message_Reference($warning_Message_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($warning_Message_Reference) && !is_string($warning_Message_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warning_Message_Reference, true), gettype($warning_Message_Reference)), __LINE__);
        }
        $this->Warning_Message_Reference = $warning_Message_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
