<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Undo_Move_from_Hire_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: The job application event that was included in this undo move.
 * @subpackage Structs
 */
class Put_Undo_Move_from_Hire_ResponseType extends AbstractStructBase
{
    /**
     * The Job_Application_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job application event that was included in this undo move.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Job_Application_Event_Reference;
    /**
     * The Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Following the undo move, the stage the candidate was moved back to.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Stage__Workday_Owned_ObjectType
     */
    public $Stage_Reference;
    /**
     * The Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reason associated with this business process.
     * - minOccurs: 0
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Reason_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Undo_Move_from_Hire_ResponseType
     * @uses Put_Undo_Move_from_Hire_ResponseType::setJob_Application_Event_Reference()
     * @uses Put_Undo_Move_from_Hire_ResponseType::setStage_Reference()
     * @uses Put_Undo_Move_from_Hire_ResponseType::setReason_Reference()
     * @uses Put_Undo_Move_from_Hire_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null, \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null, $version = null)
    {
        $this
            ->setJob_Application_Event_Reference($job_Application_Event_Reference)
            ->setStage_Reference($stage_Reference)
            ->setReason_Reference($reason_Reference)
            ->setVersion($version);
    }
    /**
     * Get Job_Application_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getJob_Application_Event_Reference()
    {
        return $this->Job_Application_Event_Reference;
    }
    /**
     * Set Job_Application_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_ResponseType
     */
    public function setJob_Application_Event_Reference(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null)
    {
        $this->Job_Application_Event_Reference = $job_Application_Event_Reference;
        return $this;
    }
    /**
     * Get Stage_Reference value
     * @return \StructType\Recruiting_Stage__Workday_Owned_ObjectType|null
     */
    public function getStage_Reference()
    {
        return $this->Stage_Reference;
    }
    /**
     * Set Stage_Reference value
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_ResponseType
     */
    public function setStage_Reference(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $stage_Reference = null)
    {
        $this->Stage_Reference = $stage_Reference;
        return $this;
    }
    /**
     * Get Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getReason_Reference()
    {
        return $this->Reason_Reference;
    }
    /**
     * Set Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_ResponseType
     */
    public function setReason_Reference(\StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null)
    {
        $this->Reason_Reference = $reason_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Undo_Move_from_Hire_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
