<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Recruiting_Self-Schedule_Calendar_Type_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the request to add, update or delete a Recruiting Self-Schedule Calendar Type.
 * @subpackage Structs
 */
class Put_Recruiting_Self_Schedule_Calendar_Type_RequestType extends AbstractStructBase
{
    /**
     * The Recruiting_Self_Schedule_Calendar_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Self-Schedule Calendar Type.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType
     */
    public $Recruiting_Self_Schedule_Calendar_Type_Reference;
    /**
     * The Recruiting_Self_Schedule_Calendar_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing data for the Recruiting Self-Schedule Calendar Type.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType
     */
    public $Recruiting_Self_Schedule_Calendar_Type_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the request is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a delete operation.
     * @var bool
     */
    public $Delete;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Recruiting_Self-Schedule_Calendar_Type_RequestType
     * @uses Put_Recruiting_Self_Schedule_Calendar_Type_RequestType::setRecruiting_Self_Schedule_Calendar_Type_Reference()
     * @uses Put_Recruiting_Self_Schedule_Calendar_Type_RequestType::setRecruiting_Self_Schedule_Calendar_Type_Data()
     * @uses Put_Recruiting_Self_Schedule_Calendar_Type_RequestType::setAdd_Only()
     * @uses Put_Recruiting_Self_Schedule_Calendar_Type_RequestType::setDelete()
     * @uses Put_Recruiting_Self_Schedule_Calendar_Type_RequestType::setVersion()
     * @param \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $recruiting_Self_Schedule_Calendar_Type_Reference
     * @param \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType $recruiting_Self_Schedule_Calendar_Type_Data
     * @param bool $add_Only
     * @param bool $delete
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $recruiting_Self_Schedule_Calendar_Type_Reference = null, \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType $recruiting_Self_Schedule_Calendar_Type_Data = null, $add_Only = null, $delete = null, $version = null)
    {
        $this
            ->setRecruiting_Self_Schedule_Calendar_Type_Reference($recruiting_Self_Schedule_Calendar_Type_Reference)
            ->setRecruiting_Self_Schedule_Calendar_Type_Data($recruiting_Self_Schedule_Calendar_Type_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete)
            ->setVersion($version);
    }
    /**
     * Get Recruiting_Self_Schedule_Calendar_Type_Reference value
     * @return \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType|null
     */
    public function getRecruiting_Self_Schedule_Calendar_Type_Reference()
    {
        return $this->{'Recruiting_Self-Schedule_Calendar_Type_Reference'};
    }
    /**
     * Set Recruiting_Self_Schedule_Calendar_Type_Reference value
     * @param \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $recruiting_Self_Schedule_Calendar_Type_Reference
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType
     */
    public function setRecruiting_Self_Schedule_Calendar_Type_Reference(\StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $recruiting_Self_Schedule_Calendar_Type_Reference = null)
    {
        $this->Recruiting_Self_Schedule_Calendar_Type_Reference = $this->{'Recruiting_Self-Schedule_Calendar_Type_Reference'} = $recruiting_Self_Schedule_Calendar_Type_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Self_Schedule_Calendar_Type_Data value
     * @return \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType|null
     */
    public function getRecruiting_Self_Schedule_Calendar_Type_Data()
    {
        return $this->{'Recruiting_Self-Schedule_Calendar_Type_Data'};
    }
    /**
     * Set Recruiting_Self_Schedule_Calendar_Type_Data value
     * @param \StructType\Recruiting_Self_Schedule_Calendar_Type_DataType $recruiting_Self_Schedule_Calendar_Type_Data
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType
     */
    public function setRecruiting_Self_Schedule_Calendar_Type_Data(\StructType\Recruiting_Self_Schedule_Calendar_Type_DataType $recruiting_Self_Schedule_Calendar_Type_Data = null)
    {
        $this->Recruiting_Self_Schedule_Calendar_Type_Data = $this->{'Recruiting_Self-Schedule_Calendar_Type_Data'} = $recruiting_Self_Schedule_Calendar_Type_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
