<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Recruiting_Agency_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the request data to add or update a Recruiting Agency
 * @subpackage Structs
 */
class Put_Recruiting_Agency_RequestType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Recruiting Agency Site.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_SiteObjectType
     */
    public $Recruiting_Agency_Reference;
    /**
     * The Recruiting_Agency_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data about the Recruiting Agency
     * @var \StructType\Recruiting_Agency_DataType
     */
    public $Recruiting_Agency_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Recruiting_Agency_RequestType
     * @uses Put_Recruiting_Agency_RequestType::setRecruiting_Agency_Reference()
     * @uses Put_Recruiting_Agency_RequestType::setRecruiting_Agency_Data()
     * @uses Put_Recruiting_Agency_RequestType::setAdd_Only()
     * @uses Put_Recruiting_Agency_RequestType::setVersion()
     * @param \StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference
     * @param \StructType\Recruiting_Agency_DataType $recruiting_Agency_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference = null, \StructType\Recruiting_Agency_DataType $recruiting_Agency_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRecruiting_Agency_Reference($recruiting_Agency_Reference)
            ->setRecruiting_Agency_Data($recruiting_Agency_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Recruiting_Agency_Reference value
     * @return \StructType\Recruiting_Agency_SiteObjectType|null
     */
    public function getRecruiting_Agency_Reference()
    {
        return $this->Recruiting_Agency_Reference;
    }
    /**
     * Set Recruiting_Agency_Reference value
     * @param \StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference
     * @return \StructType\Put_Recruiting_Agency_RequestType
     */
    public function setRecruiting_Agency_Reference(\StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference = null)
    {
        $this->Recruiting_Agency_Reference = $recruiting_Agency_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Agency_Data value
     * @return \StructType\Recruiting_Agency_DataType|null
     */
    public function getRecruiting_Agency_Data()
    {
        return $this->Recruiting_Agency_Data;
    }
    /**
     * Set Recruiting_Agency_Data value
     * @param \StructType\Recruiting_Agency_DataType $recruiting_Agency_Data
     * @return \StructType\Put_Recruiting_Agency_RequestType
     */
    public function setRecruiting_Agency_Data(\StructType\Recruiting_Agency_DataType $recruiting_Agency_Data = null)
    {
        $this->Recruiting_Agency_Data = $recruiting_Agency_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Recruiting_Agency_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Recruiting_Agency_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
