<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Primary_Posting_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Primary Posting Response.
 * @subpackage Structs
 */
class Put_Primary_Posting_ResponseType extends AbstractStructBase
{
    /**
     * The Primary_Posting_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_DataType[]
     */
    public $Primary_Posting_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Primary_Posting_ResponseType
     * @uses Put_Primary_Posting_ResponseType::setPrimary_Posting_Data()
     * @uses Put_Primary_Posting_ResponseType::setVersion()
     * @param \StructType\Job_Posting_DataType[] $primary_Posting_Data
     * @param string $version
     */
    public function __construct(array $primary_Posting_Data = array(), $version = null)
    {
        $this
            ->setPrimary_Posting_Data($primary_Posting_Data)
            ->setVersion($version);
    }
    /**
     * Get Primary_Posting_Data value
     * @return \StructType\Job_Posting_DataType[]|null
     */
    public function getPrimary_Posting_Data()
    {
        return $this->Primary_Posting_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimary_Posting_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimary_Posting_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimary_Posting_DataForArrayConstraintsFromSetPrimary_Posting_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Primary_Posting_ResponseTypePrimary_Posting_DataItem) {
            // validation for constraint: itemType
            if (!$put_Primary_Posting_ResponseTypePrimary_Posting_DataItem instanceof \StructType\Job_Posting_DataType) {
                $invalidValues[] = is_object($put_Primary_Posting_ResponseTypePrimary_Posting_DataItem) ? get_class($put_Primary_Posting_ResponseTypePrimary_Posting_DataItem) : sprintf('%s(%s)', gettype($put_Primary_Posting_ResponseTypePrimary_Posting_DataItem), var_export($put_Primary_Posting_ResponseTypePrimary_Posting_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Primary_Posting_Data property can only contain items of type \StructType\Job_Posting_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Primary_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_DataType[] $primary_Posting_Data
     * @return \StructType\Put_Primary_Posting_ResponseType
     */
    public function setPrimary_Posting_Data(array $primary_Posting_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($primary_Posting_DataArrayErrorMessage = self::validatePrimary_Posting_DataForArrayConstraintsFromSetPrimary_Posting_Data($primary_Posting_Data))) {
            throw new \InvalidArgumentException($primary_Posting_DataArrayErrorMessage, __LINE__);
        }
        $this->Primary_Posting_Data = $primary_Posting_Data;
        return $this;
    }
    /**
     * Add item to Primary_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_DataType $item
     * @return \StructType\Put_Primary_Posting_ResponseType
     */
    public function addToPrimary_Posting_Data(\StructType\Job_Posting_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_DataType) {
            throw new \InvalidArgumentException(sprintf('The Primary_Posting_Data property can only contain items of type \StructType\Job_Posting_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Primary_Posting_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Primary_Posting_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
