<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Masked_Recruiting_Configuration_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Masked Configuration Request elements
 * @subpackage Structs
 */
class Put_Masked_Recruiting_Configuration_RequestType extends AbstractStructBase
{
    /**
     * The Masked_Recruiting_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: Masked Configuration Reference
     * - minOccurs: 0
     * @var \StructType\Masked_ConfigurationObjectType
     */
    public $Masked_Recruiting_Configuration_Reference;
    /**
     * The Masked_Recruiting_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Container for Masked Configuration Data
     * - minOccurs: 0
     * @var \StructType\Masked_Recruiting_Configuration_DataType
     */
    public $Masked_Recruiting_Configuration_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if Masked Configuration Reference is add only
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if Masked Configuration Reference should be deleted
     * @var bool
     */
    public $Delete;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Masked_Recruiting_Configuration_RequestType
     * @uses Put_Masked_Recruiting_Configuration_RequestType::setMasked_Recruiting_Configuration_Reference()
     * @uses Put_Masked_Recruiting_Configuration_RequestType::setMasked_Recruiting_Configuration_Data()
     * @uses Put_Masked_Recruiting_Configuration_RequestType::setAdd_Only()
     * @uses Put_Masked_Recruiting_Configuration_RequestType::setDelete()
     * @uses Put_Masked_Recruiting_Configuration_RequestType::setVersion()
     * @param \StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference
     * @param \StructType\Masked_Recruiting_Configuration_DataType $masked_Recruiting_Configuration_Data
     * @param bool $add_Only
     * @param bool $delete
     * @param string $version
     */
    public function __construct(\StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference = null, \StructType\Masked_Recruiting_Configuration_DataType $masked_Recruiting_Configuration_Data = null, $add_Only = null, $delete = null, $version = null)
    {
        $this
            ->setMasked_Recruiting_Configuration_Reference($masked_Recruiting_Configuration_Reference)
            ->setMasked_Recruiting_Configuration_Data($masked_Recruiting_Configuration_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete)
            ->setVersion($version);
    }
    /**
     * Get Masked_Recruiting_Configuration_Reference value
     * @return \StructType\Masked_ConfigurationObjectType|null
     */
    public function getMasked_Recruiting_Configuration_Reference()
    {
        return $this->Masked_Recruiting_Configuration_Reference;
    }
    /**
     * Set Masked_Recruiting_Configuration_Reference value
     * @param \StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference
     * @return \StructType\Put_Masked_Recruiting_Configuration_RequestType
     */
    public function setMasked_Recruiting_Configuration_Reference(\StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference = null)
    {
        $this->Masked_Recruiting_Configuration_Reference = $masked_Recruiting_Configuration_Reference;
        return $this;
    }
    /**
     * Get Masked_Recruiting_Configuration_Data value
     * @return \StructType\Masked_Recruiting_Configuration_DataType|null
     */
    public function getMasked_Recruiting_Configuration_Data()
    {
        return $this->Masked_Recruiting_Configuration_Data;
    }
    /**
     * Set Masked_Recruiting_Configuration_Data value
     * @param \StructType\Masked_Recruiting_Configuration_DataType $masked_Recruiting_Configuration_Data
     * @return \StructType\Put_Masked_Recruiting_Configuration_RequestType
     */
    public function setMasked_Recruiting_Configuration_Data(\StructType\Masked_Recruiting_Configuration_DataType $masked_Recruiting_Configuration_Data = null)
    {
        $this->Masked_Recruiting_Configuration_Data = $masked_Recruiting_Configuration_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Masked_Recruiting_Configuration_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Put_Masked_Recruiting_Configuration_RequestType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Masked_Recruiting_Configuration_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
