<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Masked_Job_Requisition_Default_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the request to create or update the Masked Job Requisition Defaults for this tenant. This web service is full sync, meaning the data entered will replace all of the current default rules. Submit your entire set of
 * rules in one request.
 * @subpackage Structs
 */
class Put_Masked_Job_Requisition_Default_RequestType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is add only, not an update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Job_Requisition_Masking_Rule_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference the representation of the Masked Job Requisition Defaults table.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType
     */
    public $Job_Requisition_Masking_Rule_Configuration_Reference;
    /**
     * The Job_Requisition_Masking_Rule_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing data for the Masked Job Application Defaults table.
     * @var \StructType\Job_Requisition_Masking_Rule_Configuration_DataType
     */
    public $Job_Requisition_Masking_Rule_Configuration_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Masked_Job_Requisition_Default_RequestType
     * @uses Put_Masked_Job_Requisition_Default_RequestType::setAdd_Only()
     * @uses Put_Masked_Job_Requisition_Default_RequestType::setJob_Requisition_Masking_Rule_Configuration_Reference()
     * @uses Put_Masked_Job_Requisition_Default_RequestType::setJob_Requisition_Masking_Rule_Configuration_Data()
     * @uses Put_Masked_Job_Requisition_Default_RequestType::setVersion()
     * @param bool $add_Only
     * @param \StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType $job_Requisition_Masking_Rule_Configuration_Reference
     * @param \StructType\Job_Requisition_Masking_Rule_Configuration_DataType $job_Requisition_Masking_Rule_Configuration_Data
     * @param string $version
     */
    public function __construct($add_Only = null, \StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType $job_Requisition_Masking_Rule_Configuration_Reference = null, \StructType\Job_Requisition_Masking_Rule_Configuration_DataType $job_Requisition_Masking_Rule_Configuration_Data = null, $version = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setJob_Requisition_Masking_Rule_Configuration_Reference($job_Requisition_Masking_Rule_Configuration_Reference)
            ->setJob_Requisition_Masking_Rule_Configuration_Data($job_Requisition_Masking_Rule_Configuration_Data)
            ->setVersion($version);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Masked_Job_Requisition_Default_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Job_Requisition_Masking_Rule_Configuration_Reference value
     * @return \StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType|null
     */
    public function getJob_Requisition_Masking_Rule_Configuration_Reference()
    {
        return $this->Job_Requisition_Masking_Rule_Configuration_Reference;
    }
    /**
     * Set Job_Requisition_Masking_Rule_Configuration_Reference value
     * @param \StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType $job_Requisition_Masking_Rule_Configuration_Reference
     * @return \StructType\Put_Masked_Job_Requisition_Default_RequestType
     */
    public function setJob_Requisition_Masking_Rule_Configuration_Reference(\StructType\Job_Requisition_Masking_Rule_Configuration_SingletonObjectType $job_Requisition_Masking_Rule_Configuration_Reference = null)
    {
        $this->Job_Requisition_Masking_Rule_Configuration_Reference = $job_Requisition_Masking_Rule_Configuration_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Masking_Rule_Configuration_Data value
     * @return \StructType\Job_Requisition_Masking_Rule_Configuration_DataType|null
     */
    public function getJob_Requisition_Masking_Rule_Configuration_Data()
    {
        return $this->Job_Requisition_Masking_Rule_Configuration_Data;
    }
    /**
     * Set Job_Requisition_Masking_Rule_Configuration_Data value
     * @param \StructType\Job_Requisition_Masking_Rule_Configuration_DataType $job_Requisition_Masking_Rule_Configuration_Data
     * @return \StructType\Put_Masked_Job_Requisition_Default_RequestType
     */
    public function setJob_Requisition_Masking_Rule_Configuration_Data(\StructType\Job_Requisition_Masking_Rule_Configuration_DataType $job_Requisition_Masking_Rule_Configuration_Data = null)
    {
        $this->Job_Requisition_Masking_Rule_Configuration_Data = $job_Requisition_Masking_Rule_Configuration_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Masked_Job_Requisition_Default_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
