<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Job_Posting_Site_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container which holds the request data for a Job Posting Site Put service.
 * @subpackage Structs
 */
class Put_Job_Posting_Site_RequestType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Container to optionally select a specific Generic Job Posting Site using Reference ID. If none is specified then a new Generic Job Posting Site will be created with the data passed in the Job Posting Site Detail Data Element.
     * - minOccurs: 0
     * @var \StructType\Generic_Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The Job_Posting_Site_Data
     * Meta information extracted from the WSDL
     * - documentation: Container to hold the details of a Job Posting Site to be created or updated.
     * @var \StructType\Job_Posting_Site_Detail_DataType
     */
    public $Job_Posting_Site_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Job_Posting_Site_RequestType
     * @uses Put_Job_Posting_Site_RequestType::setJob_Posting_Site_Reference()
     * @uses Put_Job_Posting_Site_RequestType::setJob_Posting_Site_Data()
     * @uses Put_Job_Posting_Site_RequestType::setAdd_Only()
     * @uses Put_Job_Posting_Site_RequestType::setVersion()
     * @param \StructType\Generic_Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param \StructType\Job_Posting_Site_Detail_DataType $job_Posting_Site_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Generic_Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, \StructType\Job_Posting_Site_Detail_DataType $job_Posting_Site_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setJob_Posting_Site_Data($job_Posting_Site_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Generic_Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @param \StructType\Generic_Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Put_Job_Posting_Site_RequestType
     */
    public function setJob_Posting_Site_Reference(\StructType\Generic_Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Data value
     * @return \StructType\Job_Posting_Site_Detail_DataType|null
     */
    public function getJob_Posting_Site_Data()
    {
        return $this->Job_Posting_Site_Data;
    }
    /**
     * Set Job_Posting_Site_Data value
     * @param \StructType\Job_Posting_Site_Detail_DataType $job_Posting_Site_Data
     * @return \StructType\Put_Job_Posting_Site_RequestType
     */
    public function setJob_Posting_Site_Data(\StructType\Job_Posting_Site_Detail_DataType $job_Posting_Site_Data = null)
    {
        $this->Job_Posting_Site_Data = $job_Posting_Site_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Job_Posting_Site_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Job_Posting_Site_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
