<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Interview_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Put Interview response.
 * @subpackage Structs
 */
class Put_Interview_ResponseType extends AbstractStructBase
{
    /**
     * The Interview_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an interview event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Interview_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Interview_ResponseType
     * @uses Put_Interview_ResponseType::setInterview_Reference()
     * @uses Put_Interview_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $interview_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $interview_Reference = null, $version = null)
    {
        $this
            ->setInterview_Reference($interview_Reference)
            ->setVersion($version);
    }
    /**
     * Get Interview_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getInterview_Reference()
    {
        return $this->Interview_Reference;
    }
    /**
     * Set Interview_Reference value
     * @param \StructType\Unique_IdentifierObjectType $interview_Reference
     * @return \StructType\Put_Interview_ResponseType
     */
    public function setInterview_Reference(\StructType\Unique_IdentifierObjectType $interview_Reference = null)
    {
        $this->Interview_Reference = $interview_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Interview_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
