<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Candidate_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Put Candidate response.
 * @subpackage Structs
 */
class Put_Candidate_ResponseType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Candidate.
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Candidate_Job_Application_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains references to the job applications for the Candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Job_Application_DataType[]
     */
    public $Candidate_Job_Application_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Candidate_ResponseType
     * @uses Put_Candidate_ResponseType::setCandidate_Reference()
     * @uses Put_Candidate_ResponseType::setCandidate_Job_Application_Data()
     * @uses Put_Candidate_ResponseType::setVersion()
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Candidate_Job_Application_DataType[] $candidate_Job_Application_Data
     * @param string $version
     */
    public function __construct(\StructType\CandidateObjectType $candidate_Reference = null, array $candidate_Job_Application_Data = array(), $version = null)
    {
        $this
            ->setCandidate_Reference($candidate_Reference)
            ->setCandidate_Job_Application_Data($candidate_Job_Application_Data)
            ->setVersion($version);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Put_Candidate_ResponseType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Candidate_Job_Application_Data value
     * @return \StructType\Candidate_Job_Application_DataType[]|null
     */
    public function getCandidate_Job_Application_Data()
    {
        return $this->Candidate_Job_Application_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Job_Application_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Job_Application_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Job_Application_DataForArrayConstraintsFromSetCandidate_Job_Application_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Candidate_ResponseTypeCandidate_Job_Application_DataItem) {
            // validation for constraint: itemType
            if (!$put_Candidate_ResponseTypeCandidate_Job_Application_DataItem instanceof \StructType\Candidate_Job_Application_DataType) {
                $invalidValues[] = is_object($put_Candidate_ResponseTypeCandidate_Job_Application_DataItem) ? get_class($put_Candidate_ResponseTypeCandidate_Job_Application_DataItem) : sprintf('%s(%s)', gettype($put_Candidate_ResponseTypeCandidate_Job_Application_DataItem), var_export($put_Candidate_ResponseTypeCandidate_Job_Application_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Job_Application_Data property can only contain items of type \StructType\Candidate_Job_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Job_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Job_Application_DataType[] $candidate_Job_Application_Data
     * @return \StructType\Put_Candidate_ResponseType
     */
    public function setCandidate_Job_Application_Data(array $candidate_Job_Application_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Job_Application_DataArrayErrorMessage = self::validateCandidate_Job_Application_DataForArrayConstraintsFromSetCandidate_Job_Application_Data($candidate_Job_Application_Data))) {
            throw new \InvalidArgumentException($candidate_Job_Application_DataArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Job_Application_Data = $candidate_Job_Application_Data;
        return $this;
    }
    /**
     * Add item to Candidate_Job_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Job_Application_DataType $item
     * @return \StructType\Put_Candidate_ResponseType
     */
    public function addToCandidate_Job_Application_Data(\StructType\Candidate_Job_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Job_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Job_Application_Data property can only contain items of type \StructType\Candidate_Job_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Job_Application_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Candidate_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
