<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Background_Check_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request to update the status of a Background Check on a person. This operation assumes that the Background Check is using a Background Check Package.
 * @subpackage Structs
 */
class Put_Background_Check_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Dynamic_Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dynamic_Business_Process_ParametersType
     */
    public $Dynamic_Business_Process_Parameters;
    /**
     * The Background_Check_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains Background Check Information
     * @var \StructType\Background_Check_DataType
     */
    public $Background_Check_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Background_Check_RequestType
     * @uses Put_Background_Check_RequestType::setBusiness_Process_Parameters()
     * @uses Put_Background_Check_RequestType::setDynamic_Business_Process_Parameters()
     * @uses Put_Background_Check_RequestType::setBackground_Check_Data()
     * @uses Put_Background_Check_RequestType::setVersion()
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters
     * @param \StructType\Background_Check_DataType $background_Check_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters = null, \StructType\Background_Check_DataType $background_Check_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setDynamic_Business_Process_Parameters($dynamic_Business_Process_Parameters)
            ->setBackground_Check_Data($background_Check_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Put_Background_Check_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Dynamic_Business_Process_Parameters value
     * @return \StructType\Dynamic_Business_Process_ParametersType|null
     */
    public function getDynamic_Business_Process_Parameters()
    {
        return $this->Dynamic_Business_Process_Parameters;
    }
    /**
     * Set Dynamic_Business_Process_Parameters value
     * @param \StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters
     * @return \StructType\Put_Background_Check_RequestType
     */
    public function setDynamic_Business_Process_Parameters(\StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters = null)
    {
        $this->Dynamic_Business_Process_Parameters = $dynamic_Business_Process_Parameters;
        return $this;
    }
    /**
     * Get Background_Check_Data value
     * @return \StructType\Background_Check_DataType|null
     */
    public function getBackground_Check_Data()
    {
        return $this->Background_Check_Data;
    }
    /**
     * Set Background_Check_Data value
     * @param \StructType\Background_Check_DataType $background_Check_Data
     * @return \StructType\Put_Background_Check_RequestType
     */
    public function setBackground_Check_Data(\StructType\Background_Check_DataType $background_Check_Data = null)
    {
        $this->Background_Check_Data = $background_Check_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Background_Check_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
