<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prospect_Attachments_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resume/Cover Letter Attachments for prospect
 * @subpackage Structs
 */
class Prospect_Attachments_DataType extends AbstractStructBase
{
    /**
     * The Resume_Attachments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment_WWS_DataType[]
     */
    public $Resume_Attachments;
    /**
     * Constructor method for Prospect_Attachments_DataType
     * @uses Prospect_Attachments_DataType::setResume_Attachments()
     * @param \StructType\Attachment_WWS_DataType[] $resume_Attachments
     */
    public function __construct(array $resume_Attachments = array())
    {
        $this
            ->setResume_Attachments($resume_Attachments);
    }
    /**
     * Get Resume_Attachments value
     * @return \StructType\Attachment_WWS_DataType[]|null
     */
    public function getResume_Attachments()
    {
        return $this->Resume_Attachments;
    }
    /**
     * This method is responsible for validating the values passed to the setResume_Attachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResume_Attachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResume_AttachmentsForArrayConstraintsFromSetResume_Attachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prospect_Attachments_DataTypeResume_AttachmentsItem) {
            // validation for constraint: itemType
            if (!$prospect_Attachments_DataTypeResume_AttachmentsItem instanceof \StructType\Attachment_WWS_DataType) {
                $invalidValues[] = is_object($prospect_Attachments_DataTypeResume_AttachmentsItem) ? get_class($prospect_Attachments_DataTypeResume_AttachmentsItem) : sprintf('%s(%s)', gettype($prospect_Attachments_DataTypeResume_AttachmentsItem), var_export($prospect_Attachments_DataTypeResume_AttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resume_Attachments property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resume_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType[] $resume_Attachments
     * @return \StructType\Prospect_Attachments_DataType
     */
    public function setResume_Attachments(array $resume_Attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($resume_AttachmentsArrayErrorMessage = self::validateResume_AttachmentsForArrayConstraintsFromSetResume_Attachments($resume_Attachments))) {
            throw new \InvalidArgumentException($resume_AttachmentsArrayErrorMessage, __LINE__);
        }
        $this->Resume_Attachments = $resume_Attachments;
        return $this;
    }
    /**
     * Add item to Resume_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType $item
     * @return \StructType\Prospect_Attachments_DataType
     */
    public function addToResume_Attachments(\StructType\Attachment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resume_Attachments property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resume_Attachments[] = $item;
        return $this;
    }
}
