<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Salary_Unit_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Unit Salary Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Salary_Unit_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Unit_Salary_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit salary plan to update or assign. Doesn't default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Salary_Unit_PlanObjectType
     */
    public $Unit_Salary_Plan_Reference;
    /**
     * The Per_Unit_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount per unit of the unit salary plan. Decimal precision of the amount must match the currency. Required if there is no default amount for the plan. | Amount per unit of the unit allowance plan. Required if there is no default
     * amount per unit for the plan.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Per_Unit_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the unit amount. Required if there is no default currency for the plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Default_Units
     * Meta information extracted from the WSDL
     * - documentation: Number of units to assign.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Default_Units;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the unit salary plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * Constructor method for Proposed_Salary_Unit_Plan_Assignment_DataType
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setUnit_Salary_Plan_Reference()
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setPer_Unit_Amount()
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setDefault_Units()
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Salary_Unit_Plan_Assignment_DataType::setActual_End_Date()
     * @param \StructType\Salary_Unit_PlanObjectType $unit_Salary_Plan_Reference
     * @param float $per_Unit_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $default_Units
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param string $actual_End_Date
     */
    public function __construct(\StructType\Salary_Unit_PlanObjectType $unit_Salary_Plan_Reference = null, $per_Unit_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $default_Units = null, \StructType\FrequencyObjectType $frequency_Reference = null, $actual_End_Date = null)
    {
        $this
            ->setUnit_Salary_Plan_Reference($unit_Salary_Plan_Reference)
            ->setPer_Unit_Amount($per_Unit_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setDefault_Units($default_Units)
            ->setFrequency_Reference($frequency_Reference)
            ->setActual_End_Date($actual_End_Date);
    }
    /**
     * Get Unit_Salary_Plan_Reference value
     * @return \StructType\Salary_Unit_PlanObjectType|null
     */
    public function getUnit_Salary_Plan_Reference()
    {
        return $this->Unit_Salary_Plan_Reference;
    }
    /**
     * Set Unit_Salary_Plan_Reference value
     * @param \StructType\Salary_Unit_PlanObjectType $unit_Salary_Plan_Reference
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setUnit_Salary_Plan_Reference(\StructType\Salary_Unit_PlanObjectType $unit_Salary_Plan_Reference = null)
    {
        $this->Unit_Salary_Plan_Reference = $unit_Salary_Plan_Reference;
        return $this;
    }
    /**
     * Get Per_Unit_Amount value
     * @return float|null
     */
    public function getPer_Unit_Amount()
    {
        return $this->Per_Unit_Amount;
    }
    /**
     * Set Per_Unit_Amount value
     * @param float $per_Unit_Amount
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setPer_Unit_Amount($per_Unit_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($per_Unit_Amount) && !(is_float($per_Unit_Amount) || is_numeric($per_Unit_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($per_Unit_Amount, true), gettype($per_Unit_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($per_Unit_Amount) && mb_strlen(mb_substr($per_Unit_Amount, false !== mb_strpos($per_Unit_Amount, '.') ? mb_strpos($per_Unit_Amount, '.') + 1 : mb_strlen($per_Unit_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($per_Unit_Amount, true), mb_strlen(mb_substr($per_Unit_Amount, mb_strpos($per_Unit_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($per_Unit_Amount) && mb_strlen(preg_replace('/(\D)/', '', $per_Unit_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($per_Unit_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $per_Unit_Amount))), __LINE__);
        }
        $this->Per_Unit_Amount = $per_Unit_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Default_Units value
     * @return float|null
     */
    public function getDefault_Units()
    {
        return $this->Default_Units;
    }
    /**
     * Set Default_Units value
     * @param float $default_Units
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setDefault_Units($default_Units = null)
    {
        // validation for constraint: float
        if (!is_null($default_Units) && !(is_float($default_Units) || is_numeric($default_Units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Units, true), gettype($default_Units)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($default_Units) && mb_strlen(mb_substr($default_Units, false !== mb_strpos($default_Units, '.') ? mb_strpos($default_Units, '.') + 1 : mb_strlen($default_Units))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($default_Units, true), mb_strlen(mb_substr($default_Units, mb_strpos($default_Units, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Units) && $default_Units < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Units, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($default_Units) && mb_strlen(preg_replace('/(\D)/', '', $default_Units)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($default_Units, true), mb_strlen(preg_replace('/(\D)/', '', $default_Units))), __LINE__);
        }
        $this->Default_Units = $default_Units;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
}
