<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Base_Pay_Plan_Job_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Salary or Hourly Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Base_Pay_Plan_Job_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Pay_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Salary or hourly plan to update or assign. Doesn't default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Salary_Pay_PlanObjectType
     */
    public $Pay_Plan_Reference;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount of the one time payment. Decimal precision of the amount must match the currency. This is mutually exclusive with the percent. | Amount for the allowance plan. Decimal precision of the amount must match the currency. Required
     * if amount allowance plan is entered and there is no default amount for the plan. Mutually exclusive from the percent. | Amount for the salary or hourly plan assignment. Required if the plan has no default amount. Decimal precision of the amount must
     * match the currency. Mutually exclusive from the percent.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the plan assignment.
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the salary or hourly plan. Required if the plan has no default frequency.
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Expected_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Expected end date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expected_End_Date;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * Constructor method for Proposed_Base_Pay_Plan_Job_Assignment_DataType
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setPay_Plan_Reference()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setAmount()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setExpected_End_Date()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_DataType::setActual_End_Date()
     * @param \StructType\Salary_Pay_PlanObjectType $pay_Plan_Reference
     * @param float $amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param string $expected_End_Date
     * @param string $actual_End_Date
     */
    public function __construct(\StructType\Salary_Pay_PlanObjectType $pay_Plan_Reference = null, $amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\FrequencyObjectType $frequency_Reference = null, $expected_End_Date = null, $actual_End_Date = null)
    {
        $this
            ->setPay_Plan_Reference($pay_Plan_Reference)
            ->setAmount($amount)
            ->setCurrency_Reference($currency_Reference)
            ->setFrequency_Reference($frequency_Reference)
            ->setExpected_End_Date($expected_End_Date)
            ->setActual_End_Date($actual_End_Date);
    }
    /**
     * Get Pay_Plan_Reference value
     * @return \StructType\Salary_Pay_PlanObjectType|null
     */
    public function getPay_Plan_Reference()
    {
        return $this->Pay_Plan_Reference;
    }
    /**
     * Set Pay_Plan_Reference value
     * @param \StructType\Salary_Pay_PlanObjectType $pay_Plan_Reference
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setPay_Plan_Reference(\StructType\Salary_Pay_PlanObjectType $pay_Plan_Reference = null)
    {
        $this->Pay_Plan_Reference = $pay_Plan_Reference;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Expected_End_Date value
     * @return string|null
     */
    public function getExpected_End_Date()
    {
        return $this->Expected_End_Date;
    }
    /**
     * Set Expected_End_Date value
     * @param string $expected_End_Date
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setExpected_End_Date($expected_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expected_End_Date) && !is_string($expected_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expected_End_Date, true), gettype($expected_End_Date)), __LINE__);
        }
        $this->Expected_End_Date = $expected_End_Date;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
}
