<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Salary or Hourly Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType extends AbstractStructBase
{
    /**
     * The Pay_Plan_Sub_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType[]
     */
    public $Pay_Plan_Sub_Data;
    /**
     * The Replace
     * Meta information extracted from the WSDL
     * - documentation: When True, indicates the compensation plans will replace any existing compensation plan assigned to the worker. The default value of False will add or update the compensation plans for the worker.
     * @var bool
     */
    public $Replace;
    /**
     * Constructor method for Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType::setPay_Plan_Sub_Data()
     * @uses Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType::setReplace()
     * @param \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType[] $pay_Plan_Sub_Data
     * @param bool $replace
     */
    public function __construct(array $pay_Plan_Sub_Data = array(), $replace = null)
    {
        $this
            ->setPay_Plan_Sub_Data($pay_Plan_Sub_Data)
            ->setReplace($replace);
    }
    /**
     * Get Pay_Plan_Sub_Data value
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType[]|null
     */
    public function getPay_Plan_Sub_Data()
    {
        return $this->Pay_Plan_Sub_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPay_Plan_Sub_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPay_Plan_Sub_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePay_Plan_Sub_DataForArrayConstraintsFromSetPay_Plan_Sub_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem) {
            // validation for constraint: itemType
            if (!$proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem instanceof \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType) {
                $invalidValues[] = is_object($proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem) ? get_class($proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem) : sprintf('%s(%s)', gettype($proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem), var_export($proposed_Base_Pay_Plan_Job_Assignment_Container_DataTypePay_Plan_Sub_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pay_Plan_Sub_Data property can only contain items of type \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pay_Plan_Sub_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType[] $pay_Plan_Sub_Data
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
     */
    public function setPay_Plan_Sub_Data(array $pay_Plan_Sub_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($pay_Plan_Sub_DataArrayErrorMessage = self::validatePay_Plan_Sub_DataForArrayConstraintsFromSetPay_Plan_Sub_Data($pay_Plan_Sub_Data))) {
            throw new \InvalidArgumentException($pay_Plan_Sub_DataArrayErrorMessage, __LINE__);
        }
        $this->Pay_Plan_Sub_Data = $pay_Plan_Sub_Data;
        return $this;
    }
    /**
     * Add item to Pay_Plan_Sub_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType $item
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
     */
    public function addToPay_Plan_Sub_Data(\StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Pay_Plan_Sub_Data property can only contain items of type \StructType\Proposed_Base_Pay_Plan_Job_Assignment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pay_Plan_Sub_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace value
     * @return bool|null
     */
    public function getReplace()
    {
        return $this->Replace;
    }
    /**
     * Set Replace value
     * @param bool $replace
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
     */
    public function setReplace($replace = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace) && !is_bool($replace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace, true), gettype($replace)), __LINE__);
        }
        $this->Replace = $replace;
        return $this;
    }
}
