<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Allowance_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Allowance Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Allowance_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Allowance_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Allowance Plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Allowance_Value_PlanObjectType
     */
    public $Allowance_Plan_Reference;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Percent of the calculation basis defined on the one-time payment plan. Workday calculates the amount based on this percent. This is mutually exclusive with the amount. | Percent for the allowance plan. Required if percent allowance
     * plan is entered and there is no default percent for the plan. The amount will be calculated using this percent. Mutually exclusive from the amount.
     * - base: xsd:decimal
     * - choice: Percent | Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 10
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount of the one time payment. Decimal precision of the amount must match the currency. This is mutually exclusive with the percent. | Amount for the allowance plan. Decimal precision of the amount must match the currency. Required
     * if amount allowance plan is entered and there is no default amount for the plan. Mutually exclusive from the percent. | Amount for the salary or hourly plan assignment. Required if the plan has no default amount. Decimal precision of the amount must
     * match the currency. Mutually exclusive from the percent.
     * - base: xsd:decimal
     * - choice: Percent | Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Manage_by_Compensation_Basis_Override_Amount
     * Meta information extracted from the WSDL
     * - documentation: This field allows an override amount to be specified for workerswho are managed by compensation basis.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Manage_by_Compensation_Basis_Override_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the allowance plan. Required if amount allowance plan is entered and there is no default currency for the plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the allowance plan. Required if there is no default frequency for the plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Expected_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Expected end date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expected_End_Date;
    /**
     * The Reimbursement_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Reimbursement Start Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reimbursement_Start_Date;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * The Fixed_for_Manage_by_Basis_Total
     * Meta information extracted from the WSDL
     * - documentation: This field allows a plan assignment for a remainder plan in the compensation basis algorithm to be considered a fixed plan assignment. This field is only valid for plans in the PCB of a worker that is managed by basis total where the
     * plan allows override. The flag will be ignored if the conditions are not met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fixed_for_Manage_by_Basis_Total;
    /**
     * Constructor method for Proposed_Allowance_Plan_Assignment_DataType
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setAllowance_Plan_Reference()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setPercent()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setAmount()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setManage_by_Compensation_Basis_Override_Amount()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setExpected_End_Date()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setReimbursement_Start_Date()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setActual_End_Date()
     * @uses Proposed_Allowance_Plan_Assignment_DataType::setFixed_for_Manage_by_Basis_Total()
     * @param \StructType\Allowance_Value_PlanObjectType $allowance_Plan_Reference
     * @param float $percent
     * @param float $amount
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param string $expected_End_Date
     * @param string $reimbursement_Start_Date
     * @param string $actual_End_Date
     * @param bool $fixed_for_Manage_by_Basis_Total
     */
    public function __construct(\StructType\Allowance_Value_PlanObjectType $allowance_Plan_Reference = null, $percent = null, $amount = null, $manage_by_Compensation_Basis_Override_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\FrequencyObjectType $frequency_Reference = null, $expected_End_Date = null, $reimbursement_Start_Date = null, $actual_End_Date = null, $fixed_for_Manage_by_Basis_Total = null)
    {
        $this
            ->setAllowance_Plan_Reference($allowance_Plan_Reference)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setFrequency_Reference($frequency_Reference)
            ->setExpected_End_Date($expected_End_Date)
            ->setReimbursement_Start_Date($reimbursement_Start_Date)
            ->setActual_End_Date($actual_End_Date)
            ->setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total);
    }
    /**
     * Get Allowance_Plan_Reference value
     * @return \StructType\Allowance_Value_PlanObjectType|null
     */
    public function getAllowance_Plan_Reference()
    {
        return $this->Allowance_Plan_Reference;
    }
    /**
     * Set Allowance_Plan_Reference value
     * @param \StructType\Allowance_Value_PlanObjectType $allowance_Plan_Reference
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setAllowance_Plan_Reference(\StructType\Allowance_Value_PlanObjectType $allowance_Plan_Reference = null)
    {
        $this->Allowance_Plan_Reference = $allowance_Plan_Reference;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return isset($this->Percent) ? $this->Percent : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPercent method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePercentForChoiceConstraintsFromSetPercent($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Percent can\'t be set as the property %s is already set. Only one property must be set among these properties: Percent, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Percent value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $percent
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: choice(Percent, Amount)
        if ('' !== ($percentChoiceErrorMessage = self::validatePercentForChoiceConstraintsFromSetPercent($percent))) {
            throw new \InvalidArgumentException($percentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(10)
        if (!is_null($percent) && mb_strlen(mb_substr($percent, false !== mb_strpos($percent, '.') ? mb_strpos($percent, '.') + 1 : mb_strlen($percent))) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 10 fraction digits, %d given', var_export($percent, true), mb_strlen(mb_substr($percent, mb_strpos($percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent) && $percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($percent) && mb_strlen(preg_replace('/(\D)/', '', $percent)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($percent, true), mb_strlen(preg_replace('/(\D)/', '', $percent))), __LINE__);
        }
        if (is_null($percent) || (is_array($percent) && empty($percent))) {
            unset($this->Percent);
        } else {
            $this->Percent = $percent;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmountForChoiceConstraintsFromSetAmount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Amount can\'t be set as the property %s is already set. Only one property must be set among these properties: Amount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Amount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $amount
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: choice(Percent, Amount)
        if ('' !== ($amountChoiceErrorMessage = self::validateAmountForChoiceConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Manage_by_Compensation_Basis_Override_Amount value
     * @return float|null
     */
    public function getManage_by_Compensation_Basis_Override_Amount()
    {
        return $this->Manage_by_Compensation_Basis_Override_Amount;
    }
    /**
     * Set Manage_by_Compensation_Basis_Override_Amount value
     * @param float $manage_by_Compensation_Basis_Override_Amount
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setManage_by_Compensation_Basis_Override_Amount($manage_by_Compensation_Basis_Override_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && !(is_float($manage_by_Compensation_Basis_Override_Amount) || is_numeric($manage_by_Compensation_Basis_Override_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manage_by_Compensation_Basis_Override_Amount, true), gettype($manage_by_Compensation_Basis_Override_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, false !== mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') ? mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1 : mb_strlen($manage_by_Compensation_Basis_Override_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(mb_substr($manage_by_Compensation_Basis_Override_Amount, mb_strpos($manage_by_Compensation_Basis_Override_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($manage_by_Compensation_Basis_Override_Amount) && mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($manage_by_Compensation_Basis_Override_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $manage_by_Compensation_Basis_Override_Amount))), __LINE__);
        }
        $this->Manage_by_Compensation_Basis_Override_Amount = $manage_by_Compensation_Basis_Override_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Expected_End_Date value
     * @return string|null
     */
    public function getExpected_End_Date()
    {
        return $this->Expected_End_Date;
    }
    /**
     * Set Expected_End_Date value
     * @param string $expected_End_Date
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setExpected_End_Date($expected_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expected_End_Date) && !is_string($expected_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expected_End_Date, true), gettype($expected_End_Date)), __LINE__);
        }
        $this->Expected_End_Date = $expected_End_Date;
        return $this;
    }
    /**
     * Get Reimbursement_Start_Date value
     * @return string|null
     */
    public function getReimbursement_Start_Date()
    {
        return $this->Reimbursement_Start_Date;
    }
    /**
     * Set Reimbursement_Start_Date value
     * @param string $reimbursement_Start_Date
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setReimbursement_Start_Date($reimbursement_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($reimbursement_Start_Date) && !is_string($reimbursement_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reimbursement_Start_Date, true), gettype($reimbursement_Start_Date)), __LINE__);
        }
        $this->Reimbursement_Start_Date = $reimbursement_Start_Date;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
    /**
     * Get Fixed_for_Manage_by_Basis_Total value
     * @return bool|null
     */
    public function getFixed_for_Manage_by_Basis_Total()
    {
        return $this->Fixed_for_Manage_by_Basis_Total;
    }
    /**
     * Set Fixed_for_Manage_by_Basis_Total value
     * @param bool $fixed_for_Manage_by_Basis_Total
     * @return \StructType\Proposed_Allowance_Plan_Assignment_DataType
     */
    public function setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_for_Manage_by_Basis_Total) && !is_bool($fixed_for_Manage_by_Basis_Total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_for_Manage_by_Basis_Total, true), gettype($fixed_for_Manage_by_Basis_Total)), __LINE__);
        }
        $this->Fixed_for_Manage_by_Basis_Total = $fixed_for_Manage_by_Basis_Total;
        return $this;
    }
}
